"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _propsUtil = require("../_util/props-util");

var _configProvider = require("../config-provider");

var _dropdown = _interopRequireDefault(require("../dropdown/dropdown"));

var _DownOutlined = _interopRequireDefault(require("@ant-design/icons-vue/DownOutlined"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default2 = (0, _vue.defineComponent)({
  name: 'ABreadcrumbItem',
  __ANT_BREADCRUMB_ITEM: true,
  props: {
    prefixCls: _vueTypes.default.string,
    href: _vueTypes.default.string,
    separator: _vueTypes.default.VNodeChild.def('/'),
    overlay: _vueTypes.default.VNodeChild
  },
  setup: function setup() {
    return {
      configProvider: (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider)
    };
  },
  methods: {
    /**
     * if overlay is have
     * Wrap a DropDown
     */
    renderBreadcrumbNode: function renderBreadcrumbNode(breadcrumbItem, prefixCls) {
      var overlay = (0, _propsUtil.getComponent)(this, 'overlay');

      if (overlay) {
        return (0, _vue.createVNode)(_dropdown.default, {
          "overlay": overlay,
          "placement": "bottomCenter"
        }, {
          default: function _default() {
            return [(0, _vue.createVNode)("span", {
              "class": "".concat(prefixCls, "-overlay-link")
            }, [breadcrumbItem, (0, _vue.createVNode)(_DownOutlined.default, null, null)])];
          }
        });
      }

      return breadcrumbItem;
    }
  },
  render: function render() {
    var customizePrefixCls = this.prefixCls;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('breadcrumb', customizePrefixCls);
    var separator = (0, _propsUtil.getComponent)(this, 'separator');
    var children = (0, _propsUtil.getSlot)(this);
    var link;

    if ((0, _propsUtil.hasProp)(this, 'href')) {
      link = (0, _vue.createVNode)("a", {
        "class": "".concat(prefixCls, "-link")
      }, [children]);
    } else {
      link = (0, _vue.createVNode)("span", {
        "class": "".concat(prefixCls, "-link")
      }, [children]);
    } // wrap to dropDown


    link = this.renderBreadcrumbNode(link, prefixCls);

    if (children) {
      return (0, _vue.createVNode)("span", null, [link, separator && separator !== '' && (0, _vue.createVNode)("span", {
        "class": "".concat(prefixCls, "-separator")
      }, [separator])]);
    }

    return null;
  }
});

exports.default = _default2;