import { VNodeTypes, PropType, VNode } from 'vue';
export interface CardTabListType {
    key: string;
    tab: VNodeTypes;
    slots?: {
        tab: string;
    };
    disabled?: boolean;
}
export declare type CardType = 'inner';
declare const Card: import("vue").DefineComponent<{
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    title: import("vue-types").VueTypeValidableDef<import("../_util/type").VueNode>;
    extra: import("vue-types").VueTypeValidableDef<import("../_util/type").VueNode>;
    bordered: import("vue-types").VueTypeValidableDef<boolean> & {
        default: boolean;
    };
    bodyStyle: import("vue-types").VueTypeValidableDef<import("vue").CSSProperties>;
    headStyle: import("vue-types").VueTypeValidableDef<import("vue").CSSProperties>;
    loading: import("vue-types").VueTypeValidableDef<boolean> & {
        default: boolean;
    };
    hoverable: import("vue-types").VueTypeValidableDef<boolean> & {
        default: boolean;
    };
    type: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    size: import("vue-types").VueTypeDef<"default" | "small">;
    actions: import("vue-types").VueTypeValidableDef<import("../_util/type").VueNode>;
    tabList: {
        type: PropType<CardTabListType[]>;
    };
    tabBarExtraContent: import("vue-types").VueTypeValidableDef<import("../_util/type").VueNode>;
    activeTabKey: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    defaultActiveTabKey: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    cover: import("vue-types").VueTypeValidableDef<import("../_util/type").VueNode>;
    onTabChange: {
        type: PropType<(key: string) => void>;
    };
}, {
    configProvider: import("../config-provider").ConfigConsumerProps;
}, {
    widerPadding: boolean;
}, {}, {
    getAction(actions: VNodeTypes[]): JSX.Element[];
    triggerTabChange(key: string): void;
    isContainGrid(obj?: VNode[]): boolean;
}, {
    methods: {
        setState(state: {}, callback: any): void;
        __emit(...args: any[]): void;
    };
}, import("vue").ComponentOptionsMixin, Record<string, any>, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    prefixCls: string;
    type: string;
    loading: boolean;
    bordered: boolean;
    hoverable: boolean;
    activeTabKey: string;
    defaultActiveTabKey: string;
} & {
    title?: import("../_util/type").VueNode;
    cover?: import("../_util/type").VueNode;
    size?: "default" | "small";
    bodyStyle?: import("vue").CSSProperties;
    extra?: import("../_util/type").VueNode;
    actions?: import("../_util/type").VueNode;
    tabBarExtraContent?: import("../_util/type").VueNode;
    headStyle?: import("vue").CSSProperties;
    tabList?: CardTabListType[];
    onTabChange?: (key: string) => void;
}>, {
    prefixCls: string;
    type: string;
    loading: boolean;
    bordered: boolean;
    hoverable: boolean;
    activeTabKey: string;
    defaultActiveTabKey: string;
}>;
export default Card;
