"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.formProps = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _classNames2 = _interopRequireDefault(require("../_util/classNames"));

var _warning = _interopRequireDefault(require("../_util/warning"));

var _FormItem = _interopRequireDefault(require("./FormItem"));

var _propsUtil = require("../_util/props-util");

var _configProvider = require("../config-provider");

var _valueUtil = require("./utils/valueUtil");

var _messages = require("./utils/messages");

var _asyncUtil = require("./utils/asyncUtil");

var _typeUtil = require("./utils/typeUtil");

var _isEqual = _interopRequireDefault(require("lodash-es/isEqual"));

var _scrollIntoViewIfNeeded = _interopRequireDefault(require("scroll-into-view-if-needed"));

var _initDefaultProps = _interopRequireDefault(require("../_util/props-util/initDefaultProps"));

var _type = require("../_util/type");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

var formProps = {
  layout: _vueTypes.default.oneOf((0, _type.tuple)('horizontal', 'inline', 'vertical')),
  labelCol: {
    type: Object
  },
  wrapperCol: {
    type: Object
  },
  colon: _vueTypes.default.looseBool,
  labelAlign: _vueTypes.default.oneOf((0, _type.tuple)('left', 'right')),
  prefixCls: _vueTypes.default.string,
  hideRequiredMark: _vueTypes.default.looseBool,
  model: _vueTypes.default.object,
  rules: {
    type: Object
  },
  validateMessages: _vueTypes.default.object,
  validateOnRuleChange: _vueTypes.default.looseBool,
  // 提交失败自动滚动到第一个错误字段
  scrollToFirstError: {
    type: [Boolean, Object]
  },
  onSubmit: _vueTypes.default.func,
  onFinish: _vueTypes.default.func,
  onFinishFailed: _vueTypes.default.func,
  name: _vueTypes.default.string,
  validateTrigger: {
    type: [String, Array]
  }
};
exports.formProps = formProps;

function isEqualName(name1, name2) {
  return (0, _isEqual.default)((0, _typeUtil.toArray)(name1), (0, _typeUtil.toArray)(name2));
}

var Form = (0, _vue.defineComponent)({
  name: 'AForm',
  inheritAttrs: false,
  props: (0, _initDefaultProps.default)(formProps, {
    layout: 'horizontal',
    hideRequiredMark: false,
    colon: true
  }),
  Item: _FormItem.default,
  setup: function setup(props) {
    return {
      configProvider: (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider),
      fields: [],
      form: undefined,
      lastValidatePromise: null,
      vertical: (0, _vue.computed)(function () {
        return props.layout === 'vertical';
      })
    };
  },
  watch: {
    rules: function rules() {
      if (this.validateOnRuleChange) {
        this.validateFields();
      }
    }
  },
  created: function created() {
    (0, _vue.provide)('FormContext', this);
  },
  methods: {
    addField: function addField(field) {
      if (field) {
        this.fields.push(field);
      }
    },
    removeField: function removeField(field) {
      if (field.fieldName) {
        this.fields.splice(this.fields.indexOf(field), 1);
      }
    },
    handleSubmit: function handleSubmit(e) {
      var _this = this;

      e.preventDefault();
      e.stopPropagation();
      this.$emit('submit', e);
      var res = this.validateFields();
      res.then(function (values) {
        _this.$emit('finish', values);
      }).catch(function (errors) {
        _this.handleFinishFailed(errors);
      });
    },
    getFieldsByNameList: function getFieldsByNameList(nameList) {
      var provideNameList = !!nameList;
      var namePathList = provideNameList ? (0, _typeUtil.toArray)(nameList).map(_valueUtil.getNamePath) : [];

      if (!provideNameList) {
        return this.fields;
      } else {
        return this.fields.filter(function (field) {
          return namePathList.findIndex(function (namePath) {
            return isEqualName(namePath, field.fieldName);
          }) > -1;
        });
      }
    },
    resetFields: function resetFields(name) {
      if (!this.model) {
        (0, _warning.default)(false, 'Form', 'model is required for resetFields to work.');
        return;
      }

      this.getFieldsByNameList(name).forEach(function (field) {
        field.resetField();
      });
    },
    clearValidate: function clearValidate(name) {
      this.getFieldsByNameList(name).forEach(function (field) {
        field.clearValidate();
      });
    },
    handleFinishFailed: function handleFinishFailed(errorInfo) {
      var scrollToFirstError = this.scrollToFirstError;
      this.$emit('finishFailed', errorInfo);

      if (scrollToFirstError && errorInfo.errorFields.length) {
        var scrollToFieldOptions = {};

        if (_typeof(scrollToFirstError) === 'object') {
          scrollToFieldOptions = scrollToFirstError;
        }

        this.scrollToField(errorInfo.errorFields[0].name, scrollToFieldOptions);
      }
    },
    validate: function validate() {
      return this.validateField.apply(this, arguments);
    },
    scrollToField: function scrollToField(name) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fields = this.getFieldsByNameList(name);

      if (fields.length) {
        var fieldId = fields[0].fieldId;
        var node = fieldId ? document.getElementById(fieldId) : null;

        if (node) {
          (0, _scrollIntoViewIfNeeded.default)(node, _extends({
            scrollMode: 'if-needed',
            block: 'nearest'
          }, options));
        }
      }
    },
    // eslint-disable-next-line no-unused-vars
    getFieldsValue: function getFieldsValue() {
      var nameList = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
      var values = {};
      this.fields.forEach(function (_ref) {
        var fieldName = _ref.fieldName,
            fieldValue = _ref.fieldValue;
        values[fieldName] = fieldValue;
      });

      if (nameList === true) {
        return values;
      } else {
        var res = {};
        (0, _typeUtil.toArray)(nameList).forEach(function (namePath) {
          return res[namePath] = values[namePath];
        });
        return res;
      }
    },
    validateFields: function validateFields(nameList, options) {
      var _this2 = this;

      (0, _warning.default)(!(nameList instanceof Function), 'Form', 'validateFields/validateField/validate not support callback, please use promise instead');

      if (!this.model) {
        (0, _warning.default)(false, 'Form', 'model is required for validateFields to work.');
        return Promise.reject('Form `model` is required for validateFields to work.');
      }

      var provideNameList = !!nameList;
      var namePathList = provideNameList ? (0, _typeUtil.toArray)(nameList).map(_valueUtil.getNamePath) : []; // Collect result in promise list

      var promiseList = [];
      this.fields.forEach(function (field) {
        // Add field if not provide `nameList`
        if (!provideNameList) {
          namePathList.push(field.getNamePath());
        } // Skip if without rule


        if (!field.getRules().length) {
          return;
        }

        var fieldNamePath = field.getNamePath(); // Add field validate rule in to promise list

        if (!provideNameList || (0, _valueUtil.containsNamePath)(namePathList, fieldNamePath)) {
          var promise = field.validateRules(_extends({
            validateMessages: _extends(_extends({}, _messages.defaultValidateMessages), _this2.validateMessages)
          }, options)); // Wrap promise with field

          promiseList.push(promise.then(function () {
            return {
              name: fieldNamePath,
              errors: []
            };
          }).catch(function (errors) {
            return Promise.reject({
              name: fieldNamePath,
              errors: errors
            });
          }));
        }
      });
      var summaryPromise = (0, _asyncUtil.allPromiseFinish)(promiseList);
      this.lastValidatePromise = summaryPromise;
      var returnPromise = summaryPromise.then(function () {
        if (_this2.lastValidatePromise === summaryPromise) {
          return Promise.resolve(_this2.getFieldsValue(namePathList));
        }

        return Promise.reject([]);
      }).catch(function (results) {
        var errorList = results.filter(function (result) {
          return result && result.errors.length;
        });
        return Promise.reject({
          values: _this2.getFieldsValue(namePathList),
          errorFields: errorList,
          outOfDate: _this2.lastValidatePromise !== summaryPromise
        });
      }); // Do not throw in console

      returnPromise.catch(function (e) {
        return e;
      });
      return returnPromise;
    },
    validateField: function validateField() {
      return this.validateFields.apply(this, arguments);
    }
  },
  render: function render() {
    var _classNames;

    var customizePrefixCls = this.prefixCls,
        hideRequiredMark = this.hideRequiredMark,
        layout = this.layout,
        handleSubmit = this.handleSubmit;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('form', customizePrefixCls);

    var _a = this.$attrs,
        className = _a.class,
        restProps = __rest(_a, ["class"]);

    var formClassName = (0, _classNames2.default)(prefixCls, className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-horizontal"), layout === 'horizontal'), _defineProperty(_classNames, "".concat(prefixCls, "-vertical"), layout === 'vertical'), _defineProperty(_classNames, "".concat(prefixCls, "-inline"), layout === 'inline'), _defineProperty(_classNames, "".concat(prefixCls, "-hide-required-mark"), hideRequiredMark), _classNames));
    return (0, _vue.createVNode)("form", _objectSpread({
      "onSubmit": handleSubmit,
      "class": formClassName
    }, restProps), [(0, _propsUtil.getSlot)(this)]);
  }
});
var _default = Form;
exports.default = _default;