import { PropType, ExtractPropTypes } from 'vue';
import { ColProps } from '../grid/Col';
import { VueNode } from '../_util/type';
import { ValidateOptions } from './interface';
export declare const formItemProps: {
    id: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    htmlFor: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    label: import("vue-types").VueTypeValidableDef<VueNode>;
    help: import("vue-types").VueTypeValidableDef<VueNode>;
    extra: import("vue-types").VueTypeValidableDef<VueNode>;
    labelCol: {
        type: PropType<ColProps>;
    };
    wrapperCol: {
        type: PropType<ColProps>;
    };
    hasFeedback: import("vue-types").VueTypeValidableDef<boolean> & {
        default: boolean;
    };
    colon: import("vue-types").VueTypeValidableDef<boolean>;
    labelAlign: import("vue-types").VueTypeDef<"left" | "right">;
    prop: {
        type: PropType<string | number | string[] | number[]>;
    };
    name: {
        type: PropType<string | number | string[] | number[]>;
    };
    rules: import("vue-types").VueTypeDef<unknown[] | {
        [key: string]: any;
    }>;
    autoLink: import("vue-types").VueTypeValidableDef<boolean> & {
        default: boolean;
    };
    required: import("vue-types").VueTypeValidableDef<boolean>;
    validateFirst: import("vue-types").VueTypeValidableDef<boolean>;
    validateStatus: import("vue-types").VueTypeDef<"" | "error" | "success" | "warning" | "validating">;
    validateTrigger: {
        type: PropType<string | string[]>;
    };
    messageVariables: {
        type: PropType<Record<string, string>>;
    };
};
export declare type FormItemProps = Partial<ExtractPropTypes<typeof formItemProps>>;
declare const _default: import("vue").DefineComponent<{
    id: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    htmlFor: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    label: import("vue-types").VueTypeValidableDef<VueNode>;
    help: import("vue-types").VueTypeValidableDef<VueNode>;
    extra: import("vue-types").VueTypeValidableDef<VueNode>;
    labelCol: {
        type: PropType<ColProps>;
    };
    wrapperCol: {
        type: PropType<ColProps>;
    };
    hasFeedback: import("vue-types").VueTypeValidableDef<boolean> & {
        default: boolean;
    };
    colon: import("vue-types").VueTypeValidableDef<boolean>;
    labelAlign: import("vue-types").VueTypeDef<"left" | "right">;
    prop: {
        type: PropType<string | number | string[] | number[]>;
    };
    name: {
        type: PropType<string | number | string[] | number[]>;
    };
    rules: import("vue-types").VueTypeDef<unknown[] | {
        [key: string]: any;
    }>;
    autoLink: import("vue-types").VueTypeValidableDef<boolean> & {
        default: boolean;
    };
    required: import("vue-types").VueTypeValidableDef<boolean>;
    validateFirst: import("vue-types").VueTypeValidableDef<boolean>;
    validateStatus: import("vue-types").VueTypeDef<"" | "error" | "success" | "warning" | "validating">;
    validateTrigger: {
        type: PropType<string | string[]>;
    };
    messageVariables: {
        type: PropType<Record<string, string>>;
    };
}, {
    isFormItemChildren: boolean;
    configProvider: import("../config-provider").ConfigConsumerProps;
    FormContext: any;
    fieldId: import("vue").ComputedRef<string>;
    fieldName: import("vue").ComputedRef<string | number | string[] | number[]>;
    namePath: import("vue").ComputedRef<import("./interface").InternalNamePath>;
    isRequired: import("vue").ComputedRef<boolean>;
    getRules: () => any[];
    fieldValue: import("vue").ComputedRef<any>;
    mergedValidateTrigger: import("vue").ComputedRef<any[]>;
}, {
    validateState: "" | "error" | "success" | "warning" | "validating";
    validateMessage: string;
    validateDisabled: boolean;
    validator: {};
    helpShow: boolean;
    errors: any[];
    initialValue: any;
}, {}, {
    getNamePath(): any[];
    validateRules(options: ValidateOptions): Promise<void> | Promise<string[]>;
    onFieldBlur(): void;
    onFieldChange(): void;
    clearValidate(): void;
    resetField(): void;
    getHelpMessage(): any;
    onLabelClick(): void;
    onHelpAnimEnd(_key: string, helpShow: boolean): void;
    renderHelp(prefixCls: string): JSX.Element;
    renderExtra(prefixCls: string): JSX.Element;
    renderValidateWrapper(prefixCls: string, c1: VueNode, c2: VueNode, c3: VueNode): JSX.Element;
    renderWrapper(prefixCls: string, children: VueNode): JSX.Element;
    renderLabel(prefixCls: string): JSX.Element;
    renderChildren(prefixCls: string, child: VueNode): JSX.Element[];
    renderFormItem(child: any[]): JSX.Element;
}, {
    methods: {
        setState(state: {}, callback: any): void;
        __emit(...args: any[]): void;
    };
}, import("vue").ComponentOptionsMixin, Record<string, any>, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    prefixCls: string;
    id: string;
    htmlFor: string;
    hasFeedback: boolean;
    autoLink: boolean;
} & {
    label?: VueNode;
    help?: VueNode;
    name?: string | number | string[] | number[];
    extra?: VueNode;
    required?: boolean;
    validateTrigger?: string | string[];
    labelCol?: unknown;
    wrapperCol?: unknown;
    colon?: boolean;
    labelAlign?: "left" | "right";
    prop?: string | number | string[] | number[];
    rules?: unknown[] | {
        [key: string]: any;
    };
    validateFirst?: boolean;
    validateStatus?: "" | "error" | "success" | "warning" | "validating";
    messageVariables?: Record<string, string>;
}>, {
    prefixCls: string;
    id: string;
    htmlFor: string;
    hasFeedback: boolean;
    autoLink: boolean;
}>;
export default _default;
