import { PropType } from 'vue';
import { SiderHookProvider } from './layout';
export declare type CollapseType = 'clickTrigger' | 'responsive';
export declare const SiderProps: {
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    collapsible: import("vue-types").VueTypeValidableDef<boolean>;
    collapsed: import("vue-types").VueTypeValidableDef<boolean>;
    defaultCollapsed: import("vue-types").VueTypeValidableDef<boolean>;
    reverseArrow: import("vue-types").VueTypeValidableDef<boolean>;
    zeroWidthTriggerStyle: import("vue-types").VueTypeValidableDef<import("vue").CSSProperties>;
    trigger: import("vue-types").VueTypeValidableDef<import("../_util/type").VueNode>;
    width: import("vue-types").VueTypeDef<string | number>;
    collapsedWidth: import("vue-types").VueTypeDef<string | number>;
    breakpoint: import("vue-types").VueTypeDef<"lg" | "sm" | "xs" | "md" | "xl" | "xxl">;
    theme: import("vue-types").VueTypeDef<"dark" | "light"> & {
        default: "dark" | "light";
    };
    onBreakpoint: PropType<(broken: boolean) => void>;
    onCollapse: PropType<(collapsed: boolean, type: CollapseType) => void>;
};
export interface SiderContextProps {
    sCollapsed?: boolean;
    collapsedWidth?: string | number;
}
declare const _default: import("vue").DefineComponent<{
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    collapsible: import("vue-types").VueTypeValidableDef<boolean>;
    collapsed: import("vue-types").VueTypeValidableDef<boolean>;
    defaultCollapsed: import("vue-types").VueTypeValidableDef<boolean>;
    reverseArrow: import("vue-types").VueTypeValidableDef<boolean>;
    zeroWidthTriggerStyle: import("vue-types").VueTypeValidableDef<import("vue").CSSProperties>;
    trigger: import("vue-types").VueTypeValidableDef<import("../_util/type").VueNode>;
    width: import("vue-types").VueTypeDef<string | number>;
    collapsedWidth: import("vue-types").VueTypeDef<string | number>;
    breakpoint: import("vue-types").VueTypeDef<"lg" | "sm" | "xs" | "md" | "xl" | "xxl">;
    theme: import("vue-types").VueTypeDef<"dark" | "light"> & {
        default: "dark" | "light";
    };
    onBreakpoint: PropType<(broken: boolean) => void>;
    onCollapse: PropType<(collapsed: boolean, type: CollapseType) => void>;
}, {
    siderHook: SiderHookProvider;
    configProvider: import("../config-provider").ConfigConsumerProps;
}, {
    sCollapsed: boolean;
    below: boolean;
    belowShow: boolean;
    uniqueId: string;
    mql: MediaQueryList;
}, {}, {
    responsiveHandler(mql: MediaQueryListEvent | MediaQueryList): void;
    setCollapsed(collapsed: boolean, type: CollapseType): void;
    toggle(): void;
    belowShowChange(): void;
}, {
    methods: {
        setState(state: {}, callback: any): void;
        __emit(...args: any[]): void;
    };
}, import("vue").ComponentOptionsMixin, ("collapse" | "breakpoint" | "update:collapsed")[], "collapse" | "breakpoint" | "update:collapsed", import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    prefixCls: string;
    theme: "dark" | "light";
} & {
    width?: string | number;
    trigger?: import("../_util/type").VueNode;
    collapsible?: boolean;
    defaultCollapsed?: boolean;
    reverseArrow?: boolean;
    collapsedWidth?: string | number;
    collapsed?: boolean;
    zeroWidthTriggerStyle?: import("vue").CSSProperties;
    breakpoint?: "lg" | "sm" | "xs" | "md" | "xl" | "xxl";
    onBreakpoint?: (broken: boolean) => void;
    onCollapse?: (collapsed: boolean, type: CollapseType) => void;
}>, {
    prefixCls: string;
    theme: "dark" | "light";
}>;
export default _default;
