"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _vcMenu = require("../vc-menu");

var _propsUtil = require("../_util/props-util");

var _tooltip = _interopRequireDefault(require("../tooltip"));

var _FunctionProvider = require("../vc-menu/FunctionProvider");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var _default2 = (0, _vue.defineComponent)({
  name: 'MenuItem',
  inheritAttrs: false,
  props: _extends(_extends({}, _vcMenu.itemProps), {
    onClick: _vueTypes.default.func
  }),
  isMenuItem: true,
  setup: function setup() {
    return {
      getInlineCollapsed: (0, _vue.inject)('getInlineCollapsed', function () {
        return false;
      }),
      layoutSiderContext: (0, _vue.inject)('layoutSiderContext', {}),
      injectExtraProps: (0, _vue.inject)(_FunctionProvider.injectExtraPropsKey, function () {
        return {};
      })
    };
  },
  methods: {
    onKeyDown: function onKeyDown(e) {
      this.$refs.menuItem.onKeyDown(e);
    }
  },
  render: function render() {
    var props = (0, _propsUtil.getOptionProps)(this);

    var _Object$assign = _extends(_extends({}, props), this.injectExtraProps),
        level = _Object$assign.level,
        title = _Object$assign.title,
        rootPrefixCls = _Object$assign.rootPrefixCls;

    var getInlineCollapsed = this.getInlineCollapsed,
        attrs = this.$attrs;
    var inlineCollapsed = getInlineCollapsed();
    var tooltipTitle = title;
    var children = (0, _propsUtil.getSlot)(this);

    if (typeof title === 'undefined') {
      tooltipTitle = level === 1 ? children : '';
    } else if (title === false) {
      tooltipTitle = '';
    }

    var tooltipProps = {
      title: tooltipTitle
    };
    var siderCollapsed = this.layoutSiderContext.sCollapsed;

    if (!siderCollapsed && !inlineCollapsed) {
      tooltipProps.title = null; // Reset `visible` to fix control mode tooltip display not correct
      // ref: https://github.com/ant-design/ant-design/issues/16742

      tooltipProps.visible = false;
    }

    var itemProps = _extends(_extends(_extends(_extends({}, props), {
      title: title
    }), attrs), {
      ref: 'menuItem'
    });

    var toolTipProps = _extends(_extends({}, tooltipProps), {
      placement: 'right',
      overlayClassName: "".concat(rootPrefixCls, "-inline-collapsed-tooltip")
    });

    var item = (0, _vue.createVNode)(_vcMenu.Item, itemProps, {
      default: function _default() {
        return [children];
      }
    });
    return (0, _vue.createVNode)(_tooltip.default, toolTipProps, {
      default: function _default() {
        return [item];
      }
    });
  }
});

exports.default = _default2;