"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SkeletonTitleProps = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var skeletonTitleProps = {
  prefixCls: _vueTypes.default.string,
  width: _vueTypes.default.oneOfType([_vueTypes.default.number, _vueTypes.default.string])
};

var SkeletonTitleProps = _vueTypes.default.shape(skeletonTitleProps);

exports.SkeletonTitleProps = SkeletonTitleProps;
var Title = (0, _vue.defineComponent)({
  props: skeletonTitleProps,
  render: function render() {
    var _this$$props = this.$props,
        prefixCls = _this$$props.prefixCls,
        width = _this$$props.width;
    var zWidth = typeof width === 'number' ? "".concat(width, "px") : width;
    return (0, _vue.createVNode)("h3", {
      "class": prefixCls,
      "style": {
        width: zWidth
      }
    }, null);
  }
});
var _default = Title;
exports.default = _default;