"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SkeletonProps = void 0;

var _vue = require("vue");

var _classNames2 = _interopRequireDefault(require("../_util/classNames"));

var _vueTypes = _interopRequireWildcard(require("../_util/vue-types"));

var _propsUtil = require("../_util/props-util");

var _configProvider = require("../config-provider");

var _Avatar = _interopRequireWildcard(require("./Avatar"));

var _Title = _interopRequireWildcard(require("./Title"));

var _Paragraph = _interopRequireWildcard(require("./Paragraph"));

var _type = require("../_util/type");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var SkeletonProps = {
  active: _vueTypes.default.looseBool,
  loading: _vueTypes.default.looseBool,
  prefixCls: _vueTypes.default.string,
  children: _vueTypes.default.any,
  avatar: (0, _vueTypes.withUndefined)(_vueTypes.default.oneOfType([_vueTypes.default.string, _Avatar.SkeletonAvatarProps, _vueTypes.default.looseBool])),
  title: (0, _vueTypes.withUndefined)(_vueTypes.default.oneOfType([_vueTypes.default.looseBool, _vueTypes.default.string, _Title.SkeletonTitleProps])),
  paragraph: (0, _vueTypes.withUndefined)(_vueTypes.default.oneOfType([_vueTypes.default.looseBool, _vueTypes.default.string, _Paragraph.SkeletonParagraphProps]))
};
exports.SkeletonProps = SkeletonProps;

function getComponentProps(prop) {
  if (prop && _typeof(prop) === 'object') {
    return prop;
  }

  return {};
}

function getAvatarBasicProps(hasTitle, hasParagraph) {
  if (hasTitle && !hasParagraph) {
    return {
      shape: 'square'
    };
  }

  return {
    shape: 'circle'
  };
}

function getTitleBasicProps(hasAvatar, hasParagraph) {
  if (!hasAvatar && hasParagraph) {
    return {
      width: '38%'
    };
  }

  if (hasAvatar && hasParagraph) {
    return {
      width: '50%'
    };
  }

  return {};
}

function getParagraphBasicProps(hasAvatar, hasTitle) {
  var basicProps = {}; // Width

  if (!hasAvatar || !hasTitle) {
    basicProps.width = '61%';
  } // Rows


  if (!hasAvatar && hasTitle) {
    basicProps.rows = 3;
  } else {
    basicProps.rows = 2;
  }

  return basicProps;
}

var Skeleton = (0, _vue.defineComponent)({
  name: 'ASkeleton',
  props: (0, _propsUtil.initDefaultProps)(SkeletonProps, {
    avatar: false,
    title: true,
    paragraph: true
  }),
  setup: function setup() {
    return {
      configProvider: (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider)
    };
  },
  render: function render() {
    var _a, _b;

    var _this$$props = this.$props,
        customizePrefixCls = _this$$props.prefixCls,
        loading = _this$$props.loading,
        avatar = _this$$props.avatar,
        title = _this$$props.title,
        paragraph = _this$$props.paragraph,
        active = _this$$props.active;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('skeleton', customizePrefixCls);

    if (loading || !(0, _propsUtil.hasProp)(this, 'loading')) {
      var _classNames;

      var hasAvatar = !!avatar || avatar === '';
      var hasTitle = !!title;
      var hasParagraph = !!paragraph; // Avatar

      var avatarNode;

      if (hasAvatar) {
        var avatarProps = _extends(_extends({
          prefixCls: "".concat(prefixCls, "-avatar")
        }, getAvatarBasicProps(hasTitle, hasParagraph)), getComponentProps(avatar));

        avatarNode = (0, _vue.createVNode)("div", {
          "class": "".concat(prefixCls, "-header")
        }, [(0, _vue.createVNode)(_Avatar.default, avatarProps, null)]);
      }

      var contentNode;

      if (hasTitle || hasParagraph) {
        // Title
        var $title;

        if (hasTitle) {
          var titleProps = _extends(_extends({
            prefixCls: "".concat(prefixCls, "-title")
          }, getTitleBasicProps(hasAvatar, hasParagraph)), getComponentProps(title));

          $title = (0, _vue.createVNode)(_Title.default, titleProps, null);
        } // Paragraph


        var paragraphNode;

        if (hasParagraph) {
          var paragraphProps = _extends(_extends({
            prefixCls: "".concat(prefixCls, "-paragraph")
          }, getParagraphBasicProps(hasAvatar, hasTitle)), getComponentProps(paragraph));

          paragraphNode = (0, _vue.createVNode)(_Paragraph.default, paragraphProps, null);
        }

        contentNode = (0, _vue.createVNode)("div", {
          "class": "".concat(prefixCls, "-content")
        }, [$title, paragraphNode]);
      }

      var cls = (0, _classNames2.default)(prefixCls, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-with-avatar"), hasAvatar), _defineProperty(_classNames, "".concat(prefixCls, "-active"), active), _classNames));
      return (0, _vue.createVNode)("div", {
        "class": cls
      }, [avatarNode, contentNode]);
    }

    return (_b = (_a = this.$slots).default) === null || _b === void 0 ? void 0 : _b.call(_a);
  }
});

var _default = (0, _type.withInstall)(Skeleton);

exports.default = _default;