"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _moment = _interopRequireDefault(require("moment"));

var _interopDefault = _interopRequireDefault(require("../_util/interopDefault"));

var _initDefaultProps = _interopRequireDefault(require("../_util/props-util/initDefaultProps"));

var _Statistic = _interopRequireWildcard(require("./Statistic"));

var _utils = require("./utils");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var REFRESH_INTERVAL = 1000 / 30;

function getTime(value) {
  return (0, _interopDefault.default)(_moment.default)(value).valueOf();
}

var _default = (0, _vue.defineComponent)({
  name: 'AStatisticCountdown',
  props: (0, _initDefaultProps.default)(_Statistic.StatisticProps, {
    format: 'HH:mm:ss'
  }),
  setup: function setup() {
    return {
      countdownId: undefined
    };
  },
  mounted: function mounted() {
    this.syncTimer();
  },
  updated: function updated() {
    this.syncTimer();
  },
  beforeUnmount: function beforeUnmount() {
    this.stopTimer();
  },
  methods: {
    syncTimer: function syncTimer() {
      var value = this.$props.value;
      var timestamp = getTime(value);

      if (timestamp >= Date.now()) {
        this.startTimer();
      } else {
        this.stopTimer();
      }
    },
    startTimer: function startTimer() {
      var _this = this;

      if (this.countdownId) return;
      this.countdownId = window.setInterval(function () {
        _this.$refs.statistic.$forceUpdate();

        _this.syncTimer();
      }, REFRESH_INTERVAL);
    },
    stopTimer: function stopTimer() {
      var value = this.$props.value;

      if (this.countdownId) {
        clearInterval(this.countdownId);
        this.countdownId = undefined;
        var timestamp = getTime(value);

        if (timestamp < Date.now()) {
          this.$emit('finish');
        }
      }
    },
    formatCountdown: function formatCountdown(_ref) {
      var value = _ref.value,
          config = _ref.config;
      var format = this.$props.format;
      return (0, _utils.formatCountdown)(value, _extends(_extends({}, config), {
        format: format
      }));
    },
    valueRenderHtml: function valueRenderHtml(node) {
      return node;
    }
  },
  render: function render() {
    return (0, _vue.createVNode)(_Statistic.default, _objectSpread({
      "ref": "statistic"
    }, _extends(_extends({}, this.$props), {
      valueRender: this.valueRenderHtml,
      formatter: this.formatCountdown
    })), null);
  }
});

exports.default = _default;