"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.StatisticProps = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _propsUtil = require("../_util/props-util");

var _initDefaultProps = _interopRequireDefault(require("../_util/props-util/initDefaultProps"));

var _configProvider = require("../config-provider");

var _Number = _interopRequireDefault(require("./Number"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var StatisticProps = {
  prefixCls: _vueTypes.default.string,
  decimalSeparator: _vueTypes.default.string,
  groupSeparator: _vueTypes.default.string,
  format: _vueTypes.default.string,
  value: {
    type: [String, Number, Object]
  },
  valueStyle: _vueTypes.default.style,
  valueRender: _vueTypes.default.any,
  formatter: _vueTypes.default.any,
  precision: _vueTypes.default.number,
  prefix: _vueTypes.default.VNodeChild,
  suffix: _vueTypes.default.VNodeChild,
  title: _vueTypes.default.VNodeChild,
  onFinish: _vueTypes.default.func
};
exports.StatisticProps = StatisticProps;

var _default = (0, _vue.defineComponent)({
  name: 'AStatistic',
  props: (0, _initDefaultProps.default)(StatisticProps, {
    decimalSeparator: '.',
    groupSeparator: ','
  }),
  setup: function setup() {
    return {
      configProvider: (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider)
    };
  },
  render: function render() {
    var _this$$props = this.$props,
        customizePrefixCls = _this$$props.prefixCls,
        _this$$props$value = _this$$props.value,
        value = _this$$props$value === void 0 ? 0 : _this$$props$value,
        valueStyle = _this$$props.valueStyle,
        valueRender = _this$$props.valueRender;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('statistic', customizePrefixCls);
    var title = (0, _propsUtil.getComponent)(this, 'title');
    var prefix = (0, _propsUtil.getComponent)(this, 'prefix');
    var suffix = (0, _propsUtil.getComponent)(this, 'suffix');
    var formatter = (0, _propsUtil.getComponent)(this, 'formatter', {}, false);

    var props = _extends(_extends({}, this.$props), {
      prefixCls: prefixCls,
      value: value,
      formatter: formatter
    }); // data-for-update just for update component
    // https://github.com/vueComponent/ant-design-vue/pull/3170


    var valueNode = (0, _vue.createVNode)(_Number.default, _objectSpread({
      "data-for-update": Date.now()
    }, props), null);

    if (valueRender) {
      valueNode = valueRender(valueNode);
    }

    return (0, _vue.createVNode)("div", {
      "class": prefixCls
    }, [title && (0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, "-title")
    }, [title]), (0, _vue.createVNode)("div", {
      "style": valueStyle,
      "class": "".concat(prefixCls, "-content")
    }, [prefix && (0, _vue.createVNode)("span", {
      "class": "".concat(prefixCls, "-content-prefix")
    }, [prefix]), valueNode, suffix && (0, _vue.createVNode)("span", {
      "class": "".concat(prefixCls, "-content-suffix")
    }, [suffix])])]);
  }
});

exports.default = _default;