"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../../_util/vue-types"));

var _BaseMixin = _interopRequireDefault(require("../../_util/BaseMixin"));

var _propsUtil = require("../../_util/props-util");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function noop() {}

var _default = {
  name: 'Star',
  mixins: [_BaseMixin.default],
  inheritAttrs: false,
  props: {
    value: _vueTypes.default.number,
    index: _vueTypes.default.number,
    prefixCls: _vueTypes.default.string,
    allowHalf: _vueTypes.default.looseBool,
    disabled: _vueTypes.default.looseBool,
    character: _vueTypes.default.any,
    characterRender: _vueTypes.default.func,
    focused: _vueTypes.default.looseBool,
    count: _vueTypes.default.number
  },
  methods: {
    onHover: function onHover(e) {
      var index = this.index;

      this.__emit('hover', e, index);
    },
    onClick: function onClick(e) {
      var index = this.index;

      this.__emit('click', e, index);
    },
    onKeyDown: function onKeyDown(e) {
      var index = this.$props.index;

      if (e.keyCode === 13) {
        this.__emit('click', e, index);
      }
    },
    getClassName: function getClassName() {
      var prefixCls = this.prefixCls,
          index = this.index,
          value = this.value,
          allowHalf = this.allowHalf,
          focused = this.focused;
      var starValue = index + 1;
      var className = prefixCls;

      if (value === 0 && index === 0 && focused) {
        className += " ".concat(prefixCls, "-focused");
      } else if (allowHalf && value + 0.5 === starValue) {
        className += " ".concat(prefixCls, "-half ").concat(prefixCls, "-active");

        if (focused) {
          className += " ".concat(prefixCls, "-focused");
        }
      } else {
        className += starValue <= value ? " ".concat(prefixCls, "-full") : " ".concat(prefixCls, "-zero");

        if (starValue === value && focused) {
          className += " ".concat(prefixCls, "-focused");
        }
      }

      return className;
    }
  },
  render: function render() {
    var onHover = this.onHover,
        onClick = this.onClick,
        onKeyDown = this.onKeyDown,
        disabled = this.disabled,
        prefixCls = this.prefixCls,
        characterRender = this.characterRender,
        index = this.index,
        count = this.count,
        value = this.value;
    var character = (0, _propsUtil.getComponent)(this, 'character');
    var star = (0, _vue.createVNode)("li", {
      "class": this.getClassName()
    }, [(0, _vue.createVNode)("div", {
      "onClick": disabled ? noop : onClick,
      "onKeydown": disabled ? noop : onKeyDown,
      "onMousemove": disabled ? noop : onHover,
      "role": "radio",
      "aria-checked": value > index ? 'true' : 'false',
      "aria-posinset": index + 1,
      "aria-setsize": count,
      "tabindex": 0
    }, [(0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, "-first")
    }, [character]), (0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, "-second")
    }, [character])])]);

    if (characterRender) {
      star = characterRender(star, this.$props);
    }

    return star;
  }
};
exports.default = _default;