"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../../_util/vue-types"));

var _TableHeaderRow = _interopRequireDefault(require("./TableHeaderRow"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function getHeaderRows(_ref) {
  var _ref$columns = _ref.columns,
      columns = _ref$columns === void 0 ? [] : _ref$columns,
      _ref$currentRow = _ref.currentRow,
      currentRow = _ref$currentRow === void 0 ? 0 : _ref$currentRow,
      _ref$rows = _ref.rows,
      rows = _ref$rows === void 0 ? [] : _ref$rows,
      _ref$isLast = _ref.isLast,
      isLast = _ref$isLast === void 0 ? true : _ref$isLast;
  rows = rows || [];
  rows[currentRow] = rows[currentRow] || [];
  columns.forEach(function (column, i) {
    if (column.rowSpan && rows.length < column.rowSpan) {
      while (rows.length < column.rowSpan) {
        rows.push([]);
      }
    }

    var cellIsLast = isLast && i === columns.length - 1;
    var cell = {
      key: column.key,
      className: column.className || column.class || '',
      children: column.title,
      isLast: cellIsLast,
      column: column
    };

    if (column.children) {
      getHeaderRows({
        columns: column.children,
        currentRow: currentRow + 1,
        rows: rows,
        isLast: cellIsLast
      });
    }

    if ('colSpan' in column) {
      cell.colSpan = column.colSpan;
    }

    if ('rowSpan' in column) {
      cell.rowSpan = column.rowSpan;
    }

    if (cell.colSpan !== 0) {
      rows[currentRow].push(cell);
    }
  });
  return rows.filter(function (row) {
    return row.length > 0;
  });
}

var _default2 = {
  name: 'TableHeader',
  inheritAttrs: false,
  props: {
    fixed: _vueTypes.default.string,
    columns: _vueTypes.default.array.isRequired,
    expander: _vueTypes.default.object.isRequired
  },
  setup: function setup() {
    return {
      table: (0, _vue.inject)('table', {})
    };
  },
  render: function render() {
    var _this$table = this.table,
        components = _this$table.sComponents,
        prefixCls = _this$table.prefixCls,
        showHeader = _this$table.showHeader,
        customHeaderRow = _this$table.customHeaderRow;
    var expander = this.expander,
        columns = this.columns,
        fixed = this.fixed;

    if (!showHeader) {
      return null;
    }

    var rows = getHeaderRows({
      columns: columns
    });
    expander.renderExpandIndentCell(rows, fixed);
    var HeaderWrapper = components.header.wrapper;
    return (0, _vue.createVNode)(HeaderWrapper, {
      "class": "".concat(prefixCls, "-thead")
    }, {
      default: function _default() {
        return [rows.map(function (row, index) {
          return (0, _vue.createVNode)(_TableHeaderRow.default, {
            "prefixCls": prefixCls,
            "key": index,
            "index": index,
            "fixed": fixed,
            "columns": columns,
            "rows": rows,
            "row": row,
            "components": components,
            "customHeaderRow": customHeaderRow
          }, null);
        })];
      }
    });
  }
};
exports.default = _default2;