import { createVNode as _createVNode } from "vue";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { defineComponent, inject, nextTick } from 'vue';
import PropTypes from '../_util/vue-types';
import { getComponent } from '../_util/props-util';
import classNames from '../_util/classNames';
import { defaultConfigProvider } from '../config-provider'; // eslint-disable-next-line @typescript-eslint/no-unused-vars

function noop() {}

var AnchorLinkProps = {
  prefixCls: PropTypes.string,
  href: PropTypes.string.def('#'),
  title: PropTypes.VNodeChild,
  target: PropTypes.string
};
export default defineComponent({
  name: 'AAnchorLink',
  props: AnchorLinkProps,
  setup: function setup() {
    return {
      antAnchor: inject('antAnchor', {
        registerLink: noop,
        unregisterLink: noop,
        scrollTo: noop,
        $data: {}
      }),
      antAnchorContext: inject('antAnchorContext', {}),
      configProvider: inject('configProvider', defaultConfigProvider)
    };
  },
  watch: {
    href: function href(val, oldVal) {
      var _this = this;

      nextTick(function () {
        _this.antAnchor.unregisterLink(oldVal);

        _this.antAnchor.registerLink(val);
      });
    }
  },
  mounted: function mounted() {
    this.antAnchor.registerLink(this.href);
  },
  beforeUnmount: function beforeUnmount() {
    this.antAnchor.unregisterLink(this.href);
  },
  methods: {
    handleClick: function handleClick(e) {
      this.antAnchor.scrollTo(this.href);
      var scrollTo = this.antAnchor.scrollTo;
      var _this$$props = this.$props,
          href = _this$$props.href,
          title = _this$$props.title;

      if (this.antAnchorContext.$emit) {
        this.antAnchorContext.$emit('click', e, {
          title: title,
          href: href
        });
      }

      scrollTo(href);
    }
  },
  render: function render() {
    var _a;

    var customizePrefixCls = this.prefixCls,
        href = this.href,
        $slots = this.$slots,
        target = this.target;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('anchor', customizePrefixCls);
    var title = getComponent(this, 'title');
    var active = this.antAnchor.$data.activeLink === href;
    var wrapperClassName = classNames("".concat(prefixCls, "-link"), _defineProperty({}, "".concat(prefixCls, "-link-active"), active));
    var titleClassName = classNames("".concat(prefixCls, "-link-title"), _defineProperty({}, "".concat(prefixCls, "-link-title-active"), active));
    return _createVNode("div", {
      "class": wrapperClassName
    }, [_createVNode("a", {
      "class": titleClassName,
      "href": href,
      "title": typeof title === 'string' ? title : '',
      "target": target,
      "onClick": this.handleClick
    }, [title]), (_a = $slots.default) === null || _a === void 0 ? void 0 : _a.call($slots)]);
  }
});