import { withDirectives as _withDirectives, vShow as _vShow, createVNode as _createVNode } from "vue";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import PropTypes from '../_util/vue-types';
import ScrollNumber from './ScrollNumber';
import classNames from '../_util/classNames';
import { initDefaultProps, getComponent, getSlot } from '../_util/props-util';
import { cloneElement } from '../_util/vnode';
import { getTransitionProps, Transition } from '../_util/transition';
import isNumeric from '../_util/isNumeric';
import { defaultConfigProvider } from '../config-provider';
import { inject, defineComponent } from 'vue';
import { tuple } from '../_util/type';
import Ribbon from './Ribbon';
import { isPresetColor } from './utils';
var BadgeProps = {
  /** Number to show in badge */
  count: PropTypes.VNodeChild,
  showZero: PropTypes.looseBool,

  /** Max count to show */
  overflowCount: PropTypes.number,

  /** whether to show red dot without number */
  dot: PropTypes.looseBool,
  prefixCls: PropTypes.string,
  scrollNumberPrefixCls: PropTypes.string,
  status: PropTypes.oneOf(tuple('success', 'processing', 'default', 'error', 'warning')),
  color: PropTypes.string,
  text: PropTypes.VNodeChild,
  offset: PropTypes.arrayOf(PropTypes.oneOfType([String, Number])),
  numberStyle: PropTypes.style,
  title: PropTypes.string
};
var Badge = defineComponent({
  name: 'ABadge',
  Ribbon: Ribbon,
  props: initDefaultProps(BadgeProps, {
    showZero: false,
    dot: false,
    overflowCount: 99
  }),
  setup: function setup() {
    return {
      configProvider: inject('configProvider', defaultConfigProvider),
      badgeCount: undefined
    };
  },
  methods: {
    getNumberedDispayCount: function getNumberedDispayCount() {
      var overflowCount = this.$props.overflowCount;
      var count = this.badgeCount;
      var displayCount = count > overflowCount ? "".concat(overflowCount, "+") : count;
      return displayCount;
    },
    getDispayCount: function getDispayCount() {
      var isDot = this.isDot(); // dot mode don't need count

      if (isDot) {
        return '';
      }

      return this.getNumberedDispayCount();
    },
    getScrollNumberTitle: function getScrollNumberTitle() {
      var title = this.$props.title;
      var count = this.badgeCount;

      if (title) {
        return title;
      }

      return typeof count === 'string' || typeof count === 'number' ? count : undefined;
    },
    getStyleWithOffset: function getStyleWithOffset() {
      var _this$$props = this.$props,
          offset = _this$$props.offset,
          numberStyle = _this$$props.numberStyle;
      return offset ? _extends({
        right: "".concat(-parseInt(offset[0], 10), "px"),
        marginTop: isNumeric(offset[1]) ? "".concat(offset[1], "px") : offset[1]
      }, numberStyle) : _extends({}, numberStyle);
    },
    getBadgeClassName: function getBadgeClassName(prefixCls, children) {
      var _classNames;

      var hasStatus = this.hasStatus();
      return classNames(prefixCls, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-status"), hasStatus), _defineProperty(_classNames, "".concat(prefixCls, "-dot-status"), hasStatus && this.dot && !this.isZero()), _defineProperty(_classNames, "".concat(prefixCls, "-not-a-wrapper"), !children.length), _classNames));
    },
    hasStatus: function hasStatus() {
      var _this$$props2 = this.$props,
          status = _this$$props2.status,
          color = _this$$props2.color;
      return !!status || !!color;
    },
    isZero: function isZero() {
      var numberedDispayCount = this.getNumberedDispayCount();
      return numberedDispayCount === '0' || numberedDispayCount === 0;
    },
    isDot: function isDot() {
      var dot = this.$props.dot;
      var isZero = this.isZero();
      return dot && !isZero || this.hasStatus();
    },
    isHidden: function isHidden() {
      var showZero = this.$props.showZero;
      var displayCount = this.getDispayCount();
      var isZero = this.isZero();
      var isDot = this.isDot();
      var isEmpty = displayCount === null || displayCount === undefined || displayCount === '';
      return (isEmpty || isZero && !showZero) && !isDot;
    },
    renderStatusText: function renderStatusText(prefixCls) {
      var text = getComponent(this, 'text');
      var hidden = this.isHidden();
      return hidden || !text ? null : _createVNode("span", {
        "class": "".concat(prefixCls, "-status-text")
      }, [text]);
    },
    renderDispayComponent: function renderDispayComponent() {
      var count = this.badgeCount;
      var customNode = count;

      if (!customNode || _typeof(customNode) !== 'object') {
        return undefined;
      }

      return cloneElement(customNode, {
        style: this.getStyleWithOffset()
      }, false);
    },
    renderBadgeNumber: function renderBadgeNumber(prefixCls, scrollNumberPrefixCls) {
      var _scrollNumberCls;

      var _this$$props3 = this.$props,
          status = _this$$props3.status,
          color = _this$$props3.color;
      var count = this.badgeCount;
      var displayCount = this.getDispayCount();
      var isDot = this.isDot();
      var hidden = this.isHidden();
      var scrollNumberCls = (_scrollNumberCls = {}, _defineProperty(_scrollNumberCls, "".concat(prefixCls, "-dot"), isDot), _defineProperty(_scrollNumberCls, "".concat(prefixCls, "-count"), !isDot), _defineProperty(_scrollNumberCls, "".concat(prefixCls, "-multiple-words"), !isDot && count && count.toString && count.toString().length > 1), _defineProperty(_scrollNumberCls, "".concat(prefixCls, "-status-").concat(status), !!status), _defineProperty(_scrollNumberCls, "".concat(prefixCls, "-status-").concat(color), isPresetColor(color)), _scrollNumberCls);
      var statusStyle = this.getStyleWithOffset();

      if (color && !isPresetColor(color)) {
        statusStyle = statusStyle || {};
        statusStyle.background = color;
      }

      return hidden ? null : _withDirectives(_createVNode(ScrollNumber, {
        "prefixCls": scrollNumberPrefixCls,
        "data-show": !hidden,
        "class": scrollNumberCls,
        "count": displayCount,
        "displayComponent": this.renderDispayComponent(),
        "title": this.getScrollNumberTitle(),
        "style": statusStyle,
        "key": "scrollNumber"
      }, null), [[_vShow, !hidden]]);
    }
  },
  render: function render() {
    var _classNames2;

    var customizePrefixCls = this.prefixCls,
        customizeScrollNumberPrefixCls = this.scrollNumberPrefixCls,
        status = this.status,
        color = this.color;
    var text = getComponent(this, 'text');
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('badge', customizePrefixCls);
    var scrollNumberPrefixCls = getPrefixCls('scroll-number', customizeScrollNumberPrefixCls);
    var children = getSlot(this);
    var count = getComponent(this, 'count');

    if (Array.isArray(count)) {
      count = count[0];
    }

    this.badgeCount = count;
    var scrollNumber = this.renderBadgeNumber(prefixCls, scrollNumberPrefixCls);
    var statusText = this.renderStatusText(prefixCls);
    var statusCls = classNames((_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefixCls, "-status-dot"), this.hasStatus()), _defineProperty(_classNames2, "".concat(prefixCls, "-status-").concat(status), !!status), _defineProperty(_classNames2, "".concat(prefixCls, "-status-").concat(color), isPresetColor(color)), _classNames2));
    var statusStyle = {};

    if (color && !isPresetColor(color)) {
      statusStyle.background = color;
    } // <Badge status="success" />


    if (!children.length && this.hasStatus()) {
      var styleWithOffset = this.getStyleWithOffset();
      var statusTextColor = styleWithOffset && styleWithOffset.color;
      return _createVNode("span", {
        "class": this.getBadgeClassName(prefixCls, children),
        "style": styleWithOffset
      }, [_createVNode("span", {
        "class": statusCls,
        "style": statusStyle
      }, null), _createVNode("span", {
        "style": {
          color: statusTextColor
        },
        "class": "".concat(prefixCls, "-status-text")
      }, [text])]);
    }

    var transitionProps = getTransitionProps(children.length ? "".concat(prefixCls, "-zoom") : '');
    return _createVNode("span", {
      "class": this.getBadgeClassName(prefixCls, children)
    }, [children, _createVNode(Transition, transitionProps, {
      default: function _default() {
        return [scrollNumber];
      }
    }), statusText]);
  }
});

Badge.install = function (app) {
  app.component(Badge.name, Badge);
  app.component(Badge.Ribbon.displayName, Badge.Ribbon);
  return app;
};

export default Badge;