import { createVNode as _createVNode } from "vue";
import { defineComponent, inject } from 'vue';
import PropTypes from '../_util/vue-types';
import { hasProp, getComponent, getSlot } from '../_util/props-util';
import { defaultConfigProvider } from '../config-provider';
import DropDown from '../dropdown/dropdown';
import DownOutlined from '@ant-design/icons-vue/DownOutlined';
export default defineComponent({
  name: 'ABreadcrumbItem',
  __ANT_BREADCRUMB_ITEM: true,
  props: {
    prefixCls: PropTypes.string,
    href: PropTypes.string,
    separator: PropTypes.VNodeChild.def('/'),
    overlay: PropTypes.VNodeChild
  },
  setup: function setup() {
    return {
      configProvider: inject('configProvider', defaultConfigProvider)
    };
  },
  methods: {
    /**
     * if overlay is have
     * Wrap a DropDown
     */
    renderBreadcrumbNode: function renderBreadcrumbNode(breadcrumbItem, prefixCls) {
      var overlay = getComponent(this, 'overlay');

      if (overlay) {
        return _createVNode(DropDown, {
          "overlay": overlay,
          "placement": "bottomCenter"
        }, {
          default: function _default() {
            return [_createVNode("span", {
              "class": "".concat(prefixCls, "-overlay-link")
            }, [breadcrumbItem, _createVNode(DownOutlined, null, null)])];
          }
        });
      }

      return breadcrumbItem;
    }
  },
  render: function render() {
    var customizePrefixCls = this.prefixCls;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('breadcrumb', customizePrefixCls);
    var separator = getComponent(this, 'separator');
    var children = getSlot(this);
    var link;

    if (hasProp(this, 'href')) {
      link = _createVNode("a", {
        "class": "".concat(prefixCls, "-link")
      }, [children]);
    } else {
      link = _createVNode("span", {
        "class": "".concat(prefixCls, "-link")
      }, [children]);
    } // wrap to dropDown


    link = this.renderBreadcrumbNode(link, prefixCls);

    if (children) {
      return _createVNode("span", null, [link, separator && separator !== '' && _createVNode("span", {
        "class": "".concat(prefixCls, "-separator")
      }, [separator])]);
    }

    return null;
  }
});