import { PropType } from 'vue';
import { VueNode } from '../_util/type';
export declare type CheckboxValueType = string | number | boolean;
export interface CheckboxOptionType {
    label: VueNode;
    value: CheckboxValueType;
    disabled?: boolean;
    indeterminate?: boolean;
    onChange?: (e: Event) => void;
}
declare const _default: import("vue").DefineComponent<{
    name: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    defaultValue: {
        type: PropType<CheckboxValueType[]>;
    };
    value: {
        type: PropType<CheckboxValueType[]>;
    };
    options: {
        type: PropType<(string | CheckboxOptionType)[]>;
    };
    disabled: import("vue-types").VueTypeValidableDef<boolean>;
    onChange: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
}, {
    configProvider: import("../config-provider").ConfigConsumerProps;
}, {
    sValue: CheckboxValueType[];
    registeredValues: any[];
}, {}, {
    getOptions(): {
        label: VueNode;
        value: CheckboxValueType;
        disabled?: boolean;
        indeterminate?: boolean;
        onChange?: (e: Event) => void;
    }[];
    cancelValue(value: CheckboxValueType): void;
    registerValue(value: CheckboxValueType): void;
    toggleOption(option: CheckboxOptionType): void;
}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("change" | "update:value")[], "change" | "update:value", import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<{
    onChange: (...args: any[]) => any;
    prefixCls: string;
    name: string;
} & {
    value?: CheckboxValueType[];
    disabled?: boolean;
    options?: (string | CheckboxOptionType)[];
    defaultValue?: CheckboxValueType[];
}>, {
    onChange: (...args: any[]) => any;
    prefixCls: string;
    name: string;
}>;
export default _default;
