import { PropType, ExtractPropTypes } from 'vue';
import FormItem from './FormItem';
import { Options } from 'scroll-into-view-if-needed';
import { VueNode } from '../_util/type';
import { ColProps } from '../grid/Col';
import { NamePath, ValidateErrorEntity, ValidateOptions } from './interface';
export declare type ValidationRule = {
    /** validation error message */
    message?: VueNode;
    /** built-in validation type, available options: https://github.com/yiminghe/async-validator#type */
    type?: string;
    /** indicates whether field is required */
    required?: boolean;
    /** treat required fields that only contain whitespace as errors */
    whitespace?: boolean;
    /** validate the exact length of a field */
    len?: number;
    /** validate the min length of a field */
    min?: number;
    /** validate the max length of a field */
    max?: number;
    /** validate the value from a list of possible values */
    enum?: string | string[];
    /** validate from a regular expression */
    pattern?: RegExp;
    /** transform a value before validation */
    transform?: (value: any) => any;
    /** custom validate function (Note: callback must be called) */
    validator?: (rule: any, value: any, callback: any, source?: any, options?: any) => any;
    trigger?: string;
};
export declare const formProps: {
    layout: import("vue-types").VueTypeDef<"inline" | "horizontal" | "vertical">;
    labelCol: {
        type: PropType<ColProps>;
    };
    wrapperCol: {
        type: PropType<ColProps>;
    };
    colon: import("vue-types").VueTypeValidableDef<boolean>;
    labelAlign: import("vue-types").VueTypeDef<"left" | "right">;
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    hideRequiredMark: import("vue-types").VueTypeValidableDef<boolean>;
    model: import("vue-types").VueTypeValidableDef<{
        [key: string]: any;
    }> & {
        default: () => {
            [key: string]: any;
        };
    };
    rules: {
        type: PropType<{
            [k: string]: ValidationRule | ValidationRule[];
        }>;
    };
    validateMessages: import("vue-types").VueTypeValidableDef<{
        [key: string]: any;
    }> & {
        default: () => {
            [key: string]: any;
        };
    };
    validateOnRuleChange: import("vue-types").VueTypeValidableDef<boolean>;
    scrollToFirstError: {
        type: PropType<boolean | Options<any>>;
    };
    onSubmit: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onFinish: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onFinishFailed: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    name: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    validateTrigger: {
        type: PropType<string | string[]>;
    };
};
export declare type FormProps = Partial<ExtractPropTypes<typeof formProps>>;
declare const _default: {
    new (...args: any[]): {
        $: import("vue").ComponentInternalInstance;
        $data: {};
        $props: Partial<{
            onSubmit: (...args: any[]) => any;
            prefixCls: string;
            name: string;
            model: {
                [key: string]: any;
            };
            validateMessages: {
                [key: string]: any;
            };
            onFinish: (...args: any[]) => any;
            onFinishFailed: (...args: any[]) => any;
        }> & Omit<Readonly<{
            onSubmit: (...args: any[]) => any;
            prefixCls: string;
            name: string;
            model: {
                [key: string]: any;
            };
            validateMessages: {
                [key: string]: any;
            };
            onFinish: (...args: any[]) => any;
            onFinishFailed: (...args: any[]) => any;
        } & {
            layout?: "inline" | "horizontal" | "vertical";
            colon?: boolean;
            validateTrigger?: string | string[];
            labelCol?: unknown;
            wrapperCol?: unknown;
            labelAlign?: "left" | "right";
            rules?: {
                [k: string]: ValidationRule | ValidationRule[];
            };
            hideRequiredMark?: boolean;
            validateOnRuleChange?: boolean;
            scrollToFirstError?: unknown;
        }> & import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, "onSubmit" | "prefixCls" | "name" | "model" | "validateMessages" | "onFinish" | "onFinishFailed">;
        $attrs: {
            [x: string]: unknown;
        };
        $refs: {
            [x: string]: unknown;
        };
        $slots: Readonly<{
            [name: string]: import("vue").Slot;
        }>;
        $root: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}>>;
        $parent: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}>>;
        $emit: (event: string, ...args: any[]) => void;
        $el: any;
        $options: import("vue").ComponentOptionsBase<Readonly<{
            onSubmit: (...args: any[]) => any;
            prefixCls: string;
            name: string;
            model: {
                [key: string]: any;
            };
            validateMessages: {
                [key: string]: any;
            };
            onFinish: (...args: any[]) => any;
            onFinishFailed: (...args: any[]) => any;
        } & {
            layout?: "inline" | "horizontal" | "vertical";
            colon?: boolean;
            validateTrigger?: string | string[];
            labelCol?: unknown;
            wrapperCol?: unknown;
            labelAlign?: "left" | "right";
            rules?: {
                [k: string]: ValidationRule | ValidationRule[];
            };
            hideRequiredMark?: boolean;
            validateOnRuleChange?: boolean;
            scrollToFirstError?: unknown;
        }>, {
            configProvider: import("../config-provider").ConfigConsumerProps;
            fields: any[];
            form: any;
            lastValidatePromise: any;
            vertical: import("vue").ComputedRef<boolean>;
        }, unknown, {}, {
            addField(field: any): void;
            removeField(field: any): void;
            handleSubmit(e: Event): void;
            getFieldsByNameList(nameList: NamePath): any[];
            resetFields(name: NamePath): void;
            clearValidate(name: NamePath): void;
            handleFinishFailed(errorInfo: ValidateErrorEntity<any>): void;
            validate(...args: any[]): Promise<any>;
            scrollToField(name: NamePath, options?: {}): void;
            getFieldsValue(nameList?: true | NamePath[]): any;
            validateFields(nameList?: NamePath[], options?: ValidateOptions): Promise<any>;
            validateField(...args: any[]): Promise<any>;
        }, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, Record<string, any>, string, {
            onSubmit: (...args: any[]) => any;
            prefixCls: string;
            name: string;
            model: {
                [key: string]: any;
            };
            validateMessages: {
                [key: string]: any;
            };
            onFinish: (...args: any[]) => any;
            onFinishFailed: (...args: any[]) => any;
        }>;
        $forceUpdate: import("vue").ReactiveEffect<any>;
        $nextTick: typeof import("vue").nextTick;
        $watch(source: string | Function, cb: Function, options?: import("vue").WatchOptions<boolean>): import("vue").WatchStopHandle;
    } & Readonly<{
        onSubmit: (...args: any[]) => any;
        prefixCls: string;
        name: string;
        model: {
            [key: string]: any;
        };
        validateMessages: {
            [key: string]: any;
        };
        onFinish: (...args: any[]) => any;
        onFinishFailed: (...args: any[]) => any;
    } & {
        layout?: "inline" | "horizontal" | "vertical";
        colon?: boolean;
        validateTrigger?: string | string[];
        labelCol?: unknown;
        wrapperCol?: unknown;
        labelAlign?: "left" | "right";
        rules?: {
            [k: string]: ValidationRule | ValidationRule[];
        };
        hideRequiredMark?: boolean;
        validateOnRuleChange?: boolean;
        scrollToFirstError?: unknown;
    }> & import("vue").ShallowUnwrapRef<{
        configProvider: import("../config-provider").ConfigConsumerProps;
        fields: any[];
        form: any;
        lastValidatePromise: any;
        vertical: import("vue").ComputedRef<boolean>;
    }> & {} & {} & {
        addField(field: any): void;
        removeField(field: any): void;
        handleSubmit(e: Event): void;
        getFieldsByNameList(nameList: NamePath): any[];
        resetFields(name: NamePath): void;
        clearValidate(name: NamePath): void;
        handleFinishFailed(errorInfo: ValidateErrorEntity<any>): void;
        validate(...args: any[]): Promise<any>;
        scrollToField(name: NamePath, options?: {}): void;
        getFieldsValue(nameList?: true | NamePath[]): any;
        validateFields(nameList?: NamePath[], options?: ValidateOptions): Promise<any>;
        validateField(...args: any[]): Promise<any>;
    } & import("vue").ComponentCustomProperties;
    __isFragment?: never;
    __isTeleport?: never;
    __isSuspense?: never;
} & import("vue").ComponentOptionsBase<Readonly<{
    onSubmit: (...args: any[]) => any;
    prefixCls: string;
    name: string;
    model: {
        [key: string]: any;
    };
    validateMessages: {
        [key: string]: any;
    };
    onFinish: (...args: any[]) => any;
    onFinishFailed: (...args: any[]) => any;
} & {
    layout?: "inline" | "horizontal" | "vertical";
    colon?: boolean;
    validateTrigger?: string | string[];
    labelCol?: unknown;
    wrapperCol?: unknown;
    labelAlign?: "left" | "right";
    rules?: {
        [k: string]: ValidationRule | ValidationRule[];
    };
    hideRequiredMark?: boolean;
    validateOnRuleChange?: boolean;
    scrollToFirstError?: unknown;
}>, {
    configProvider: import("../config-provider").ConfigConsumerProps;
    fields: any[];
    form: any;
    lastValidatePromise: any;
    vertical: import("vue").ComputedRef<boolean>;
}, unknown, {}, {
    addField(field: any): void;
    removeField(field: any): void;
    handleSubmit(e: Event): void;
    getFieldsByNameList(nameList: NamePath): any[];
    resetFields(name: NamePath): void;
    clearValidate(name: NamePath): void;
    handleFinishFailed(errorInfo: ValidateErrorEntity<any>): void;
    validate(...args: any[]): Promise<any>;
    scrollToField(name: NamePath, options?: {}): void;
    getFieldsValue(nameList?: true | NamePath[]): any;
    validateFields(nameList?: NamePath[], options?: ValidateOptions): Promise<any>;
    validateField(...args: any[]): Promise<any>;
}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, Record<string, any>, string, {
    onSubmit: (...args: any[]) => any;
    prefixCls: string;
    name: string;
    model: {
        [key: string]: any;
    };
    validateMessages: {
        [key: string]: any;
    };
    onFinish: (...args: any[]) => any;
    onFinishFailed: (...args: any[]) => any;
}> & import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps & {
    readonly Item: typeof FormItem;
};
export default _default;
