import { createVNode as _createVNode } from "vue";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var __rest = this && this.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

import { inject, defineComponent } from 'vue';
import omit from 'omit.js';
import PropTypes from '../_util/vue-types';
import { getOptionProps, getComponent } from '../_util/props-util';
import { defaultConfigProvider } from '../config-provider';
import VcRate from '../vc-rate';
import StarFilled from '@ant-design/icons-vue/StarFilled';
import Tooltip from '../tooltip';
import { withInstall } from '../_util/type';
export var RateProps = {
  prefixCls: PropTypes.string,
  count: PropTypes.number,
  value: PropTypes.number,
  defaultValue: PropTypes.number,
  allowHalf: PropTypes.looseBool,
  allowClear: PropTypes.looseBool,
  tooltips: PropTypes.arrayOf(PropTypes.string),
  disabled: PropTypes.looseBool,
  character: PropTypes.any,
  autofocus: PropTypes.looseBool
};
var Rate = defineComponent({
  name: 'ARate',
  props: RateProps,
  setup: function setup() {
    return {
      configProvider: inject('configProvider', defaultConfigProvider)
    };
  },
  methods: {
    characterRender: function characterRender(node, _ref) {
      var index = _ref.index;
      var tooltips = this.$props.tooltips;
      if (!tooltips) return node;
      return _createVNode(Tooltip, {
        "title": tooltips[index]
      }, {
        default: function _default() {
          return [node];
        }
      });
    },
    focus: function focus() {
      this.$refs.refRate.focus();
    },
    blur: function blur() {
      this.$refs.refRate.blur();
    }
  },
  render: function render() {
    var _a = getOptionProps(this),
        customizePrefixCls = _a.prefixCls,
        restProps = __rest(_a, ["prefixCls"]);

    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('rate', customizePrefixCls);

    var character = getComponent(this, 'character') || _createVNode(StarFilled, null, null);

    var rateProps = _extends(_extends(_extends({
      character: character,
      characterRender: this.characterRender,
      prefixCls: prefixCls
    }, omit(restProps, ['tooltips'])), this.$attrs), {
      ref: 'refRate'
    });

    return _createVNode(VcRate, rateProps, null);
  }
});
export default withInstall(Rate);