import { createVNode as _createVNode } from "vue";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { defineComponent } from 'vue';
import classNames from '../_util/classNames';
import PropTypes from '../_util/vue-types';
import { tuple } from '../_util/type';
import initDefaultProps from '../_util/props-util/initDefaultProps';
var skeletonAvatarProps = {
  prefixCls: PropTypes.string,
  size: PropTypes.oneOfType([PropTypes.oneOf(tuple('large', 'small', 'default')), PropTypes.number]),
  shape: PropTypes.oneOf(tuple('circle', 'square'))
};
export var SkeletonAvatarProps = PropTypes.shape(skeletonAvatarProps).loose;
var Avatar = defineComponent({
  props: initDefaultProps(skeletonAvatarProps, {
    size: 'large'
  }),
  render: function render() {
    var _classNames, _classNames2;

    var _this$$props = this.$props,
        prefixCls = _this$$props.prefixCls,
        size = _this$$props.size,
        shape = _this$$props.shape;
    var sizeCls = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-lg"), size === 'large'), _defineProperty(_classNames, "".concat(prefixCls, "-sm"), size === 'small'), _classNames));
    var shapeCls = classNames((_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefixCls, "-circle"), shape === 'circle'), _defineProperty(_classNames2, "".concat(prefixCls, "-square"), shape === 'square'), _classNames2));
    var sizeStyle = typeof size === 'number' ? {
      width: "".concat(size, "px"),
      height: "".concat(size, "px"),
      lineHeight: "".concat(size, "px")
    } : {};
    return _createVNode("span", {
      "class": classNames(prefixCls, sizeCls, shapeCls),
      "style": sizeStyle
    }, null);
  }
});
export default Avatar;