import { createVNode as _createVNode } from "vue";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import { defineComponent } from 'vue';
import moment from 'moment';
import interopDefault from '../_util/interopDefault';
import initDefaultProps from '../_util/props-util/initDefaultProps';
import Statistic, { StatisticProps } from './Statistic';
import { formatCountdown as _formatCountdown } from './utils';
var REFRESH_INTERVAL = 1000 / 30;

function getTime(value) {
  return interopDefault(moment)(value).valueOf();
}

export default defineComponent({
  name: 'AStatisticCountdown',
  props: initDefaultProps(StatisticProps, {
    format: 'HH:mm:ss'
  }),
  setup: function setup() {
    return {
      countdownId: undefined
    };
  },
  mounted: function mounted() {
    this.syncTimer();
  },
  updated: function updated() {
    this.syncTimer();
  },
  beforeUnmount: function beforeUnmount() {
    this.stopTimer();
  },
  methods: {
    syncTimer: function syncTimer() {
      var value = this.$props.value;
      var timestamp = getTime(value);

      if (timestamp >= Date.now()) {
        this.startTimer();
      } else {
        this.stopTimer();
      }
    },
    startTimer: function startTimer() {
      var _this = this;

      if (this.countdownId) return;
      this.countdownId = window.setInterval(function () {
        _this.$refs.statistic.$forceUpdate();

        _this.syncTimer();
      }, REFRESH_INTERVAL);
    },
    stopTimer: function stopTimer() {
      var value = this.$props.value;

      if (this.countdownId) {
        clearInterval(this.countdownId);
        this.countdownId = undefined;
        var timestamp = getTime(value);

        if (timestamp < Date.now()) {
          this.$emit('finish');
        }
      }
    },
    formatCountdown: function formatCountdown(_ref) {
      var value = _ref.value,
          config = _ref.config;
      var format = this.$props.format;
      return _formatCountdown(value, _extends(_extends({}, config), {
        format: format
      }));
    },
    valueRenderHtml: function valueRenderHtml(node) {
      return node;
    }
  },
  render: function render() {
    return _createVNode(Statistic, _objectSpread({
      "ref": "statistic"
    }, _extends(_extends({}, this.$props), {
      valueRender: this.valueRenderHtml,
      formatter: this.formatCountdown
    })), null);
  }
});