import { createVNode as _createVNode } from "vue";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import { defineComponent, inject } from 'vue';
import PropTypes from '../_util/vue-types';
import { getComponent } from '../_util/props-util';
import initDefaultProps from '../_util/props-util/initDefaultProps';
import { defaultConfigProvider } from '../config-provider';
import StatisticNumber from './Number';
export var StatisticProps = {
  prefixCls: PropTypes.string,
  decimalSeparator: PropTypes.string,
  groupSeparator: PropTypes.string,
  format: PropTypes.string,
  value: {
    type: [String, Number, Object]
  },
  valueStyle: PropTypes.style,
  valueRender: PropTypes.any,
  formatter: PropTypes.any,
  precision: PropTypes.number,
  prefix: PropTypes.VNodeChild,
  suffix: PropTypes.VNodeChild,
  title: PropTypes.VNodeChild,
  onFinish: PropTypes.func
};
export default defineComponent({
  name: 'AStatistic',
  props: initDefaultProps(StatisticProps, {
    decimalSeparator: '.',
    groupSeparator: ','
  }),
  setup: function setup() {
    return {
      configProvider: inject('configProvider', defaultConfigProvider)
    };
  },
  render: function render() {
    var _this$$props = this.$props,
        customizePrefixCls = _this$$props.prefixCls,
        _this$$props$value = _this$$props.value,
        value = _this$$props$value === void 0 ? 0 : _this$$props$value,
        valueStyle = _this$$props.valueStyle,
        valueRender = _this$$props.valueRender;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('statistic', customizePrefixCls);
    var title = getComponent(this, 'title');
    var prefix = getComponent(this, 'prefix');
    var suffix = getComponent(this, 'suffix');
    var formatter = getComponent(this, 'formatter', {}, false);

    var props = _extends(_extends({}, this.$props), {
      prefixCls: prefixCls,
      value: value,
      formatter: formatter
    }); // data-for-update just for update component
    // https://github.com/vueComponent/ant-design-vue/pull/3170


    var valueNode = _createVNode(StatisticNumber, _objectSpread({
      "data-for-update": Date.now()
    }, props), null);

    if (valueRender) {
      valueNode = valueRender(valueNode);
    }

    return _createVNode("div", {
      "class": prefixCls
    }, [title && _createVNode("div", {
      "class": "".concat(prefixCls, "-title")
    }, [title]), _createVNode("div", {
      "style": valueStyle,
      "class": "".concat(prefixCls, "-content")
    }, [prefix && _createVNode("span", {
      "class": "".concat(prefixCls, "-content-prefix")
    }, [prefix]), valueNode, suffix && _createVNode("span", {
      "class": "".concat(prefixCls, "-content-suffix")
    }, [suffix])])]);
  }
});