import { ImgHTMLAttributes, CSSProperties } from 'vue';
import PreviewGroup from './PreviewGroup';
export declare type GetContainer = string | HTMLElement | (() => HTMLElement);
export interface ImagePreviewType {
    visible?: boolean;
    onVisibleChange?: (value: boolean, prevValue: boolean) => void;
    getContainer?: GetContainer | false;
}
export interface ImagePropsType extends Omit<ImgHTMLAttributes, 'placeholder' | 'onClick'> {
    src?: string;
    wrapperClassName?: string;
    wrapperStyle?: CSSProperties;
    prefixCls?: string;
    previewPrefixCls?: string;
    placeholder?: boolean;
    fallback?: string;
    preview?: boolean | ImagePreviewType;
}
export declare const ImageProps: {
    src: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    wrapperClassName: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    wrapperStyle: import("vue-types").VueTypeValidableDef<CSSProperties>;
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    previewPrefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    placeholder: import("vue-types").VueTypeValidableDef<import("../../_util/type").VueNode>;
    fallback: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    preview: import("vue-types").VueTypeDef<boolean | {
        visible: (boolean | ((props: Record<string, unknown>) => boolean)) & boolean;
        onVisibleChange: any;
        getContainer: (import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
            default: (...args: any[]) => any;
        }) | (import("vue-types").VueTypeValidableDef<boolean> & {
            default: boolean;
        }) | (() => import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
            default: (...args: any[]) => any;
        }) | (() => import("vue-types").VueTypeValidableDef<boolean> & {
            default: boolean;
        });
    }> & {
        default: boolean | (() => {
            visible: (boolean | ((props: Record<string, unknown>) => boolean)) & boolean;
            onVisibleChange: any;
            getContainer: (import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
                default: (...args: any[]) => any;
            }) | (import("vue-types").VueTypeValidableDef<boolean> & {
                default: boolean;
            }) | (() => import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
                default: (...args: any[]) => any;
            }) | (() => import("vue-types").VueTypeValidableDef<boolean> & {
                default: boolean;
            });
        });
    };
};
declare const _default: {
    new (...args: any[]): {
        $: import("vue").ComponentInternalInstance;
        $data: {};
        $props: Partial<{
            prefixCls: string;
            wrapperClassName: string;
            src: string;
            previewPrefixCls: string;
            fallback: string;
            preview: boolean | {
                visible: (boolean | ((props: Record<string, unknown>) => boolean)) & boolean;
                onVisibleChange: any;
                getContainer: (import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
                    default: (...args: any[]) => any;
                }) | (import("vue-types").VueTypeValidableDef<boolean> & {
                    default: boolean;
                }) | (() => import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
                    default: (...args: any[]) => any;
                }) | (() => import("vue-types").VueTypeValidableDef<boolean> & {
                    default: boolean;
                });
            };
        }> & Omit<Readonly<{
            prefixCls: string;
            wrapperClassName: string;
            src: string;
            previewPrefixCls: string;
            fallback: string;
            preview: boolean | {
                visible: (boolean | ((props: Record<string, unknown>) => boolean)) & boolean;
                onVisibleChange: any;
                getContainer: (import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
                    default: (...args: any[]) => any;
                }) | (import("vue-types").VueTypeValidableDef<boolean> & {
                    default: boolean;
                }) | (() => import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
                    default: (...args: any[]) => any;
                }) | (() => import("vue-types").VueTypeValidableDef<boolean> & {
                    default: boolean;
                });
            };
        } & {
            placeholder?: import("../../_util/type").VueNode;
            wrapperStyle?: CSSProperties;
        }> & import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, "prefixCls" | "wrapperClassName" | "src" | "previewPrefixCls" | "fallback" | "preview">;
        $attrs: {
            [x: string]: unknown;
        };
        $refs: {
            [x: string]: unknown;
        };
        $slots: Readonly<{
            [name: string]: import("vue").Slot;
        }>;
        $root: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}>>;
        $parent: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}>>;
        $emit: (event: "click", ...args: any[]) => void;
        $el: any;
        $options: import("vue").ComponentOptionsBase<Readonly<{
            prefixCls: string;
            wrapperClassName: string;
            src: string;
            previewPrefixCls: string;
            fallback: string;
            preview: boolean | {
                visible: (boolean | ((props: Record<string, unknown>) => boolean)) & boolean;
                onVisibleChange: any;
                getContainer: (import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
                    default: (...args: any[]) => any;
                }) | (import("vue-types").VueTypeValidableDef<boolean> & {
                    default: boolean;
                }) | (() => import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
                    default: (...args: any[]) => any;
                }) | (() => import("vue-types").VueTypeValidableDef<boolean> & {
                    default: boolean;
                });
            };
        } & {
            placeholder?: import("../../_util/type").VueNode;
            wrapperStyle?: CSSProperties;
        }>, () => JSX.Element, unknown, {}, {}, {
            methods: {
                setState(state: {}, callback: any): void;
                __emit(...args: any[]): void;
            };
        }, import("vue").ComponentOptionsMixin, "click"[], string, {
            prefixCls: string;
            wrapperClassName: string;
            src: string;
            previewPrefixCls: string;
            fallback: string;
            preview: boolean | {
                visible: (boolean | ((props: Record<string, unknown>) => boolean)) & boolean;
                onVisibleChange: any;
                getContainer: (import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
                    default: (...args: any[]) => any;
                }) | (import("vue-types").VueTypeValidableDef<boolean> & {
                    default: boolean;
                }) | (() => import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
                    default: (...args: any[]) => any;
                }) | (() => import("vue-types").VueTypeValidableDef<boolean> & {
                    default: boolean;
                });
            };
        }>;
        $forceUpdate: import("vue").ReactiveEffect<any>;
        $nextTick: typeof import("vue").nextTick;
        $watch(source: string | Function, cb: Function, options?: import("vue").WatchOptions<boolean>): import("vue").WatchStopHandle;
    } & Readonly<{
        prefixCls: string;
        wrapperClassName: string;
        src: string;
        previewPrefixCls: string;
        fallback: string;
        preview: boolean | {
            visible: (boolean | ((props: Record<string, unknown>) => boolean)) & boolean;
            onVisibleChange: any;
            getContainer: (import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
                default: (...args: any[]) => any;
            }) | (import("vue-types").VueTypeValidableDef<boolean> & {
                default: boolean;
            }) | (() => import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
                default: (...args: any[]) => any;
            }) | (() => import("vue-types").VueTypeValidableDef<boolean> & {
                default: boolean;
            });
        };
    } & {
        placeholder?: import("../../_util/type").VueNode;
        wrapperStyle?: CSSProperties;
    }> & import("vue").ShallowUnwrapRef<() => JSX.Element> & {} & {
        [x: string]: never;
    } & {
        setState(state: {}, callback: any): void;
        __emit(...args: any[]): void;
    } & import("vue").ComponentCustomProperties;
    __isFragment?: never;
    __isTeleport?: never;
    __isSuspense?: never;
} & import("vue").ComponentOptionsBase<Readonly<{
    prefixCls: string;
    wrapperClassName: string;
    src: string;
    previewPrefixCls: string;
    fallback: string;
    preview: boolean | {
        visible: (boolean | ((props: Record<string, unknown>) => boolean)) & boolean;
        onVisibleChange: any;
        getContainer: (import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
            default: (...args: any[]) => any;
        }) | (import("vue-types").VueTypeValidableDef<boolean> & {
            default: boolean;
        }) | (() => import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
            default: (...args: any[]) => any;
        }) | (() => import("vue-types").VueTypeValidableDef<boolean> & {
            default: boolean;
        });
    };
} & {
    placeholder?: import("../../_util/type").VueNode;
    wrapperStyle?: CSSProperties;
}>, () => JSX.Element, unknown, {}, {}, {
    methods: {
        setState(state: {}, callback: any): void;
        __emit(...args: any[]): void;
    };
}, import("vue").ComponentOptionsMixin, "click"[], "click", {
    prefixCls: string;
    wrapperClassName: string;
    src: string;
    previewPrefixCls: string;
    fallback: string;
    preview: boolean | {
        visible: (boolean | ((props: Record<string, unknown>) => boolean)) & boolean;
        onVisibleChange: any;
        getContainer: (import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
            default: (...args: any[]) => any;
        }) | (import("vue-types").VueTypeValidableDef<boolean> & {
            default: boolean;
        }) | (() => import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
            default: (...args: any[]) => any;
        }) | (() => import("vue-types").VueTypeValidableDef<boolean> & {
            default: boolean;
        });
    };
}> & import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps & {
    readonly PreviewGroup: typeof PreviewGroup;
};
export default _default;
