// based on rc-resize-observer 0.1.3
import ResizeObserver from 'resize-observer-polyfill';
import { defineComponent } from 'vue';
import BaseMixin from '../_util/BaseMixin';
import { findDOMNode } from '../_util/props-util'; // Still need to be compatible with React 15, we use class component here

var VueResizeObserver = defineComponent({
  name: 'ResizeObserver',
  mixins: [BaseMixin],
  props: {
    disabled: Boolean,
    onResize: Function
  },
  data: function data() {
    this.currentElement = null;
    this.resizeObserver = null;
    return {
      width: 0,
      height: 0
    };
  },
  mounted: function mounted() {
    this.onComponentUpdated();
  },
  updated: function updated() {
    this.onComponentUpdated();
  },
  beforeUnmount: function beforeUnmount() {
    this.destroyObserver();
  },
  methods: {
    onComponentUpdated: function onComponentUpdated() {
      var disabled = this.$props.disabled; // Unregister if disabled

      if (disabled) {
        this.destroyObserver();
        return;
      } // Unregister if element changed


      var element = findDOMNode(this);
      var elementChanged = element !== this.currentElement;

      if (elementChanged) {
        this.destroyObserver();
        this.currentElement = element;
      }

      if (!this.resizeObserver && element) {
        this.resizeObserver = new ResizeObserver(this.handleResize);
        this.resizeObserver.observe(element);
      }
    },
    handleResize: function handleResize(entries) {
      var target = entries[0].target;

      var _target$getBoundingCl = target.getBoundingClientRect(),
          width = _target$getBoundingCl.width,
          height = _target$getBoundingCl.height;

      var offsetWidth = target.offsetWidth,
          offsetHeight = target.offsetHeight;
      /**
       * Resize observer trigger when content size changed.
       * In most case we just care about element size,
       * let's use `boundary` instead of `contentRect` here to avoid shaking.
       */

      var fixedWidth = Math.floor(width);
      var fixedHeight = Math.floor(height);

      if (this.width !== fixedWidth || this.height !== fixedHeight) {
        var size = {
          width: fixedWidth,
          height: fixedHeight,
          offsetWidth: offsetWidth,
          offsetHeight: offsetHeight
        };
        this.width = fixedWidth;
        this.height = fixedHeight;

        this.__emit('resize', size);
      }
    },
    destroyObserver: function destroyObserver() {
      if (this.resizeObserver) {
        this.resizeObserver.disconnect();
        this.resizeObserver = null;
      }
    }
  },
  render: function render() {
    var _a, _b;

    return (_b = (_a = this.$slots).default) === null || _b === void 0 ? void 0 : _b.call(_a)[0];
  }
});
export default VueResizeObserver;