"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _type = require("../_util/type");

var _utils = require("./utils");

var _configProvider = require("../config-provider");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var Ribbon = function Ribbon(props, _ref) {
  var _ref2;

  var attrs = _ref.attrs,
      slots = _ref.slots;

  var _a, _b;

  var customizePrefixCls = props.prefixCls,
      color = props.color,
      _props$text = props.text,
      text = _props$text === void 0 ? (_a = slots.text) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$text,
      _props$placement = props.placement,
      placement = _props$placement === void 0 ? 'end' : _props$placement;
  var className = attrs.class,
      style = attrs.style;
  var children = (_b = slots.default) === null || _b === void 0 ? void 0 : _b.call(slots);

  var _inject = (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider),
      getPrefixCls = _inject.getPrefixCls,
      direction = _inject.direction;

  var prefixCls = getPrefixCls('ribbon', customizePrefixCls);
  var colorInPreset = (0, _utils.isPresetColor)(color);
  var ribbonCls = [prefixCls, "".concat(prefixCls, "-placement-").concat(placement), (_ref2 = {}, _defineProperty(_ref2, "".concat(prefixCls, "-rtl"), direction === 'rtl'), _defineProperty(_ref2, "".concat(prefixCls, "-color-").concat(color), colorInPreset), _ref2), className];
  var colorStyle = {};
  var cornerColorStyle = {};

  if (color && !colorInPreset) {
    colorStyle.background = color;
    cornerColorStyle.color = color;
  }

  return (0, _vue.createVNode)("div", {
    "class": "".concat(prefixCls, "-wrapper")
  }, [children, (0, _vue.createVNode)("div", {
    "class": ribbonCls,
    "style": _extends(_extends({}, colorStyle), style)
  }, [(0, _vue.createVNode)("span", {
    "class": "".concat(prefixCls, "-text")
  }, [text]), (0, _vue.createVNode)("div", {
    "class": "".concat(prefixCls, "-corner"),
    "style": cornerColorStyle
  }, null)])]);
};

Ribbon.displayName = 'ABadgeRibbon';
Ribbon.inheritAttrs = false;
Ribbon.props = {
  prefix: _vueTypes.default.string,
  color: _vueTypes.default.string,
  text: _vueTypes.default.any,
  placement: _vueTypes.default.oneOf((0, _type.tuple)('start', 'end'))
};
var _default = Ribbon;
exports.default = _default;