"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CommentProps = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _propsUtil = require("../_util/props-util");

var _configProvider = require("../config-provider");

var _type = require("../_util/type");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var CommentProps = {
  actions: _vueTypes.default.array,

  /** The element to display as the comment author. */
  author: _vueTypes.default.VNodeChild,

  /** The element to display as the comment avatar - generally an antd Avatar */
  avatar: _vueTypes.default.VNodeChild,

  /** The main content of the comment */
  content: _vueTypes.default.VNodeChild,

  /** Comment prefix defaults to '.ant-comment' */
  prefixCls: _vueTypes.default.string,

  /** A datetime element containing the time to be displayed */
  datetime: _vueTypes.default.VNodeChild
};
exports.CommentProps = CommentProps;
var Comment = (0, _vue.defineComponent)({
  name: 'AComment',
  props: CommentProps,
  setup: function setup() {
    return {
      configProvider: (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider)
    };
  },
  methods: {
    getAction: function getAction(actions) {
      if (!actions || !actions.length) {
        return null;
      }

      var actionList = actions.map(function (action, index) {
        return (0, _vue.createVNode)("li", {
          "key": "action-".concat(index)
        }, [action]);
      });
      return actionList;
    },
    renderNested: function renderNested(prefixCls, children) {
      return (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls, "-nested")
      }, [children]);
    }
  },
  render: function render() {
    var customizePrefixCls = this.$props.prefixCls;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('comment', customizePrefixCls);
    var actions = (0, _propsUtil.getComponent)(this, 'actions');
    var author = (0, _propsUtil.getComponent)(this, 'author');
    var avatar = (0, _propsUtil.getComponent)(this, 'avatar');
    var content = (0, _propsUtil.getComponent)(this, 'content');
    var datetime = (0, _propsUtil.getComponent)(this, 'datetime');
    var avatarDom = (0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, "-avatar")
    }, [typeof avatar === 'string' ? (0, _vue.createVNode)("img", {
      "src": avatar,
      "alt": "comment-avatar"
    }, null) : avatar]);
    var actionDom = actions ? (0, _vue.createVNode)("ul", {
      "class": "".concat(prefixCls, "-actions")
    }, [this.getAction(Array.isArray(actions) ? actions : [actions])]) : null;
    var authorContent = (0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, "-content-author")
    }, [author && (0, _vue.createVNode)("span", {
      "class": "".concat(prefixCls, "-content-author-name")
    }, [author]), datetime && (0, _vue.createVNode)("span", {
      "class": "".concat(prefixCls, "-content-author-time")
    }, [datetime])]);
    var contentDom = (0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, "-content")
    }, [authorContent, (0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, "-content-detail")
    }, [content]), actionDom]);
    var comment = (0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, "-inner")
    }, [avatarDom, contentDom]);
    var children = (0, _propsUtil.getSlot)(this);
    return (0, _vue.createVNode)("div", {
      "class": prefixCls
    }, [comment, children && children.length ? this.renderNested(prefixCls, children) : null]);
  }
});

var _default = (0, _type.withInstall)(Comment);

exports.default = _default;