import { VNodeTypes } from 'vue';
import defaultRenderEmpty, { RenderEmptyHandler } from './renderEmpty';
import { Locale } from '../locale-provider';
import { TransformCellTextProps } from '../table/interface';
export declare type SizeType = 'small' | 'middle' | 'large' | undefined;
export interface CSPConfig {
    nonce?: string;
}
export { RenderEmptyHandler };
export interface ConfigConsumerProps {
    getTargetContainer?: () => HTMLElement;
    getPopupContainer?: (triggerNode: HTMLElement) => HTMLElement;
    rootPrefixCls?: string;
    getPrefixCls: (suffixCls?: string, customizePrefixCls?: string) => string;
    renderEmpty: RenderEmptyHandler;
    transformCellText?: (tableProps: TransformCellTextProps) => any;
    csp?: CSPConfig;
    autoInsertSpaceInButton?: boolean;
    input?: {
        autoComplete?: string;
    };
    locale?: Locale;
    pageHeader?: {
        ghost: boolean;
    };
    direction?: 'ltr' | 'rtl';
    space?: {
        size?: SizeType | number;
    };
    virtual?: boolean;
    dropdownMatchSelectWidth?: boolean;
}
export declare const configConsumerProps: string[];
export interface ConfigProviderProps {
    getTargetContainer?: () => HTMLElement;
    getPopupContainer?: (triggerNode: HTMLElement) => HTMLElement;
    prefixCls?: string;
    children?: VNodeTypes;
    renderEmpty?: RenderEmptyHandler;
    transformCellText?: (tableProps: TransformCellTextProps) => any;
    csp?: CSPConfig;
    autoInsertSpaceInButton?: boolean;
    input?: {
        autoComplete?: string;
    };
    locale?: Locale;
    pageHeader?: {
        ghost: boolean;
    };
    componentSize?: SizeType;
    direction?: 'ltr' | 'rtl';
    space?: {
        size?: SizeType | number;
    };
    virtual?: boolean;
    dropdownMatchSelectWidth?: boolean;
}
export declare const defaultConfigProvider: ConfigConsumerProps;
declare const _default: {
    new (...args: any[]): {
        $: import("vue").ComponentInternalInstance;
        $data: {};
        $props: Partial<{}> & Omit<Readonly<{} & {
            locale?: Locale;
            getPrefixCls?: (suffixCls?: string, customizePrefixCls?: string) => string;
            prefixCls?: string;
            direction?: "ltr" | "rtl";
            space?: number | SizeType;
            virtual?: boolean;
            dropdownMatchSelectWidth?: boolean;
            getPopupContainer?: (triggerNode: HTMLElement) => HTMLElement;
            renderEmpty?: typeof defaultRenderEmpty;
            transformCellText?: (tableProps: TransformCellTextProps) => any;
            getTargetContainer?: () => HTMLElement;
            csp?: unknown;
            autoInsertSpaceInButton?: boolean;
            pageHeader?: {
                ghost: boolean;
            };
            componentSize?: SizeType;
        }> & import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, never>;
        $attrs: {
            [x: string]: unknown;
        };
        $refs: {
            [x: string]: unknown;
        };
        $slots: Readonly<{
            [name: string]: import("vue").Slot;
        }>;
        $root: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}>>;
        $parent: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}>>;
        $emit: (event: string, ...args: any[]) => void;
        $el: any;
        $options: import("vue").ComponentOptionsBase<Readonly<{} & {
            locale?: Locale;
            getPrefixCls?: (suffixCls?: string, customizePrefixCls?: string) => string;
            prefixCls?: string;
            direction?: "ltr" | "rtl";
            space?: number | SizeType;
            virtual?: boolean;
            dropdownMatchSelectWidth?: boolean;
            getPopupContainer?: (triggerNode: HTMLElement) => HTMLElement;
            renderEmpty?: typeof defaultRenderEmpty;
            transformCellText?: (tableProps: TransformCellTextProps) => any;
            getTargetContainer?: () => HTMLElement;
            csp?: unknown;
            autoInsertSpaceInButton?: boolean;
            pageHeader?: {
                ghost: boolean;
            };
            componentSize?: SizeType;
        }>, () => JSX.Element, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, Record<string, any>, string, {}>;
        $forceUpdate: import("vue").ReactiveEffect<any>;
        $nextTick: typeof import("vue").nextTick;
        $watch(source: string | Function, cb: Function, options?: import("vue").WatchOptions<boolean>): import("vue").WatchStopHandle;
    } & Readonly<{} & {
        locale?: Locale;
        getPrefixCls?: (suffixCls?: string, customizePrefixCls?: string) => string;
        prefixCls?: string;
        direction?: "ltr" | "rtl";
        space?: number | SizeType;
        virtual?: boolean;
        dropdownMatchSelectWidth?: boolean;
        getPopupContainer?: (triggerNode: HTMLElement) => HTMLElement;
        renderEmpty?: typeof defaultRenderEmpty;
        transformCellText?: (tableProps: TransformCellTextProps) => any;
        getTargetContainer?: () => HTMLElement;
        csp?: unknown;
        autoInsertSpaceInButton?: boolean;
        pageHeader?: {
            ghost: boolean;
        };
        componentSize?: SizeType;
    }> & import("vue").ShallowUnwrapRef<() => JSX.Element> & {} & {} & import("vue").ComponentCustomProperties;
    __isFragment?: never;
    __isTeleport?: never;
    __isSuspense?: never;
} & import("vue").ComponentOptionsBase<Readonly<{} & {
    locale?: Locale;
    getPrefixCls?: (suffixCls?: string, customizePrefixCls?: string) => string;
    prefixCls?: string;
    direction?: "ltr" | "rtl";
    space?: number | SizeType;
    virtual?: boolean;
    dropdownMatchSelectWidth?: boolean;
    getPopupContainer?: (triggerNode: HTMLElement) => HTMLElement;
    renderEmpty?: typeof defaultRenderEmpty;
    transformCellText?: (tableProps: TransformCellTextProps) => any;
    getTargetContainer?: () => HTMLElement;
    csp?: unknown;
    autoInsertSpaceInButton?: boolean;
    pageHeader?: {
        ghost: boolean;
    };
    componentSize?: SizeType;
}>, () => JSX.Element, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, Record<string, any>, string, {}> & import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps & import("@vue/runtime-core").Plugin;
export default _default;
