"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _classNames2 = _interopRequireDefault(require("../_util/classNames"));

var _type = require("../_util/type");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _configProvider = require("../config-provider");

var _responsiveObserve = _interopRequireWildcard(require("../_util/responsiveObserve"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var RowAligns = (0, _type.tuple)('top', 'middle', 'bottom', 'stretch');
var RowJustify = (0, _type.tuple)('start', 'end', 'center', 'space-around', 'space-between');
var ARow = (0, _vue.defineComponent)({
  name: 'ARow',
  setup: function setup(props, _ref) {
    var slots = _ref.slots;
    var rowContext = (0, _vue.reactive)({
      gutter: undefined
    });
    (0, _vue.provide)('rowContext', rowContext);
    var token;
    (0, _vue.onMounted)(function () {
      token = _responsiveObserve.default.subscribe(function (screen) {
        var currentGutter = props.gutter || 0;

        if (!Array.isArray(currentGutter) && _typeof(currentGutter) === 'object' || Array.isArray(currentGutter) && (_typeof(currentGutter[0]) === 'object' || _typeof(currentGutter[1]) === 'object')) {
          screens.value = screen;
        }
      });
    });
    (0, _vue.onBeforeUnmount)(function () {
      _responsiveObserve.default.unsubscribe(token);
    });
    var screens = (0, _vue.ref)({
      xs: true,
      sm: true,
      md: true,
      lg: true,
      xl: true,
      xxl: true
    });

    var _inject = (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider),
        getPrefixCls = _inject.getPrefixCls;

    var getGutter = function getGutter() {
      var results = [0, 0];
      var _props$gutter = props.gutter,
          gutter = _props$gutter === void 0 ? 0 : _props$gutter;
      var normalizedGutter = Array.isArray(gutter) ? gutter : [gutter, 0];
      normalizedGutter.forEach(function (g, index) {
        if (_typeof(g) === 'object') {
          for (var i = 0; i < _responsiveObserve.responsiveArray.length; i++) {
            var breakpoint = _responsiveObserve.responsiveArray[i];

            if (screens.value[breakpoint] && g[breakpoint] !== undefined) {
              results[index] = g[breakpoint];
              break;
            }
          }
        } else {
          results[index] = g || 0;
        }
      });
      return results;
    };

    return function () {
      var _classNames;

      var _a;

      var customizePrefixCls = props.prefixCls,
          justify = props.justify,
          align = props.align;
      var prefixCls = getPrefixCls('row', customizePrefixCls);
      var gutter = getGutter();
      var classes = (0, _classNames2.default)(prefixCls, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-").concat(justify), justify), _defineProperty(_classNames, "".concat(prefixCls, "-").concat(align), align), _classNames));

      var rowStyle = _extends(_extends({}, gutter[0] > 0 ? {
        marginLeft: "".concat(gutter[0] / -2, "px"),
        marginRight: "".concat(gutter[0] / -2, "px")
      } : {}), gutter[1] > 0 ? {
        marginTop: "".concat(gutter[1] / -2, "px"),
        marginBottom: "".concat(gutter[1] / -2, "px")
      } : {});

      rowContext.gutter = gutter;
      return (0, _vue.createVNode)("div", {
        "class": classes,
        "style": rowStyle
      }, [(_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)]);
    };
  }
});
ARow.props = {
  type: _vueTypes.default.oneOf(['flex']),
  align: _vueTypes.default.oneOf(RowAligns),
  justify: _vueTypes.default.oneOf(RowJustify),
  prefixCls: _vueTypes.default.string,
  gutter: _vueTypes.default.oneOfType([_vueTypes.default.object, _vueTypes.default.number, _vueTypes.default.array]).def(0)
};
var _default = ARow;
exports.default = _default;