"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _vcMenu = require("../vc-menu");

var _classNames = _interopRequireDefault(require("../_util/classNames"));

var _FunctionProvider = require("../vc-menu/FunctionProvider");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var _default = (0, _vue.defineComponent)({
  name: 'ASubMenu',
  isSubMenu: true,
  inheritAttrs: false,
  props: _extends({}, _vcMenu.SubMenu.props),
  setup: function setup() {
    return {
      menuPropsContext: (0, _vue.inject)('menuPropsContext', {}),
      injectExtraProps: (0, _vue.inject)(_FunctionProvider.injectExtraPropsKey, function () {
        return {};
      })
    };
  },
  methods: {
    onKeyDown: function onKeyDown(e) {
      this.$refs.subMenu.onKeyDown(e);
    }
  },
  render: function render() {
    var $slots = this.$slots,
        $attrs = this.$attrs;

    var _Object$assign = _extends(_extends({}, this.$props), this.injectExtraProps),
        rootPrefixCls = _Object$assign.rootPrefixCls,
        popupClassName = _Object$assign.popupClassName;

    var antdMenuTheme = this.menuPropsContext.theme;

    var props = _extends(_extends(_extends({}, this.$props), {
      popupClassName: (0, _classNames.default)("".concat(rootPrefixCls, "-").concat(antdMenuTheme), popupClassName),
      ref: 'subMenu'
    }), $attrs);

    return (0, _vue.createVNode)(_vcMenu.SubMenu, props, $slots);
  }
});

exports.default = _default;