import { ExtractPropTypes, Plugin } from 'vue';
import { Divider, ItemGroup } from '../vc-menu';
import SubMenu from './SubMenu';
import Item from './MenuItem';
import { SiderContextProps } from '../layout/Sider';
export declare const MenuMode: import("vue-types").VueTypeDef<string>;
export declare const menuProps: {
    theme: import("vue-types").VueTypeDef<"dark" | "light"> & {
        default: "dark" | "light";
    };
    mode: import("vue-types").VueTypeDef<string> & {
        default: string;
    };
    selectable: import("vue-types").VueTypeValidableDef<boolean>;
    selectedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    defaultSelectedKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    openKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    defaultOpenKeys: import("vue-types").VueTypeDef<(string | number)[]>;
    openAnimation: import("vue-types").VueTypeDef<string | {
        [key: string]: any;
    }>;
    openTransitionName: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    prefixCls: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    };
    multiple: import("vue-types").VueTypeValidableDef<boolean>;
    inlineIndent: import("vue-types").VueTypeValidableDef<number> & {
        default: number;
    } & {
        default: number;
    };
    inlineCollapsed: import("vue-types").VueTypeValidableDef<boolean>;
    isRootMenu: import("vue-types").VueTypeValidableDef<boolean> & {
        default: boolean;
    };
    focusable: import("vue-types").VueTypeValidableDef<boolean> & {
        default: boolean;
    };
    onOpenChange: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onSelect: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onDeselect: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onClick: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onMouseenter: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    onSelectChange: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    visible: import("vue-types").VueTypeValidableDef<boolean> & {
        default: boolean;
    };
    activeKey: import("vue-types").VueTypeDef<string | number>;
    triggerSubMenuAction: import("vue-types").VueTypeValidableDef<string> & {
        default: string;
    } & {
        default: string;
    };
    subMenuOpenDelay: import("vue-types").VueTypeValidableDef<number> & {
        default: number;
    } & {
        default: number;
    };
    subMenuCloseDelay: import("vue-types").VueTypeValidableDef<number> & {
        default: number;
    } & {
        default: number;
    };
    level: import("vue-types").VueTypeValidableDef<number> & {
        default: number;
    } & {
        default: number;
    };
    getPopupContainer: import("vue-types").VueTypeValidableDef<(...args: any[]) => any> & {
        default: (...args: any[]) => any;
    };
    forceSubMenuRender: import("vue-types").VueTypeValidableDef<boolean> & {
        default: boolean;
    };
    builtinPlacements: import("vue-types").VueTypeValidableDef<{
        [key: string]: any;
    }> & {
        default: () => {
            [key: string]: any;
        };
    } & {
        default: () => {
            [key: string]: any;
        };
    };
    itemIcon: import("vue-types").VueTypeValidableDef<any>;
    expandIcon: import("vue-types").VueTypeValidableDef<any>;
    overflowedIndicator: import("vue-types").VueTypeValidableDef<any>;
};
export declare type MenuProps = Partial<ExtractPropTypes<typeof menuProps>>;
declare const _default: {
    new (...args: any[]): {
        $: import("vue").ComponentInternalInstance;
        $data: {
            sOpenKeys: (string | number)[];
        };
        $props: Partial<{
            onClick: (...args: any[]) => any;
            onMouseenter: (...args: any[]) => any;
            onSelect: (...args: any[]) => any;
            prefixCls: string;
            visible: boolean;
            mode: string;
            getPopupContainer: (...args: any[]) => any;
            builtinPlacements: {
                [key: string]: any;
            };
            onDeselect: (...args: any[]) => any;
            focusable: boolean;
            isRootMenu: boolean;
            triggerSubMenuAction: string;
            forceSubMenuRender: boolean;
            subMenuOpenDelay: number;
            subMenuCloseDelay: number;
            level: number;
            inlineIndent: number;
            openTransitionName: string;
            theme: "dark" | "light";
            onOpenChange: (...args: any[]) => any;
            onSelectChange: (...args: any[]) => any;
        }> & Omit<Readonly<{
            onClick: (...args: any[]) => any;
            onMouseenter: (...args: any[]) => any;
            onSelect: (...args: any[]) => any;
            prefixCls: string;
            visible: boolean;
            mode: string;
            getPopupContainer: (...args: any[]) => any;
            builtinPlacements: {
                [key: string]: any;
            };
            onDeselect: (...args: any[]) => any;
            focusable: boolean;
            isRootMenu: boolean;
            triggerSubMenuAction: string;
            forceSubMenuRender: boolean;
            subMenuOpenDelay: number;
            subMenuCloseDelay: number;
            level: number;
            inlineIndent: number;
            openTransitionName: string;
            theme: "dark" | "light";
            onOpenChange: (...args: any[]) => any;
            onSelectChange: (...args: any[]) => any;
        } & {
            multiple?: boolean;
            itemIcon?: any;
            expandIcon?: any;
            selectable?: boolean;
            openKeys?: (string | number)[];
            openAnimation?: string | {
                [key: string]: any;
            };
            selectedKeys?: (string | number)[];
            defaultSelectedKeys?: (string | number)[];
            defaultOpenKeys?: (string | number)[];
            inlineCollapsed?: boolean;
            activeKey?: string | number;
            overflowedIndicator?: any;
        }> & import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, "onClick" | "onMouseenter" | "onSelect" | "prefixCls" | "visible" | "mode" | "getPopupContainer" | "builtinPlacements" | "onDeselect" | "focusable" | "isRootMenu" | "triggerSubMenuAction" | "forceSubMenuRender" | "subMenuOpenDelay" | "subMenuCloseDelay" | "level" | "inlineIndent" | "openTransitionName" | "theme" | "onOpenChange" | "onSelectChange">;
        $attrs: {
            [x: string]: unknown;
        };
        $refs: {
            [x: string]: unknown;
        };
        $slots: Readonly<{
            [name: string]: import("vue").Slot;
        }>;
        $root: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}>>;
        $parent: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}>>;
        $emit: (event: "click" | "mouseenter" | "select" | "update:selectedKeys" | "update:openKeys" | "openChange" | "selectChange" | "deselect", ...args: any[]) => void;
        $el: any;
        $options: import("vue").ComponentOptionsBase<Readonly<{
            onClick: (...args: any[]) => any;
            onMouseenter: (...args: any[]) => any;
            onSelect: (...args: any[]) => any;
            prefixCls: string;
            visible: boolean;
            mode: string;
            getPopupContainer: (...args: any[]) => any;
            builtinPlacements: {
                [key: string]: any;
            };
            onDeselect: (...args: any[]) => any;
            focusable: boolean;
            isRootMenu: boolean;
            triggerSubMenuAction: string;
            forceSubMenuRender: boolean;
            subMenuOpenDelay: number;
            subMenuCloseDelay: number;
            level: number;
            inlineIndent: number;
            openTransitionName: string;
            theme: "dark" | "light";
            onOpenChange: (...args: any[]) => any;
            onSelectChange: (...args: any[]) => any;
        } & {
            multiple?: boolean;
            itemIcon?: any;
            expandIcon?: any;
            selectable?: boolean;
            openKeys?: (string | number)[];
            openAnimation?: string | {
                [key: string]: any;
            };
            selectedKeys?: (string | number)[];
            defaultSelectedKeys?: (string | number)[];
            defaultOpenKeys?: (string | number)[];
            inlineCollapsed?: boolean;
            activeKey?: string | number;
            overflowedIndicator?: any;
        }>, {
            configProvider: import("../config-provider").ConfigConsumerProps;
            layoutSiderContext: SiderContextProps;
            layoutSiderCollapsed: import("vue").Ref<boolean>;
            propsUpdating: boolean;
            switchingModeFromInline: boolean;
            leaveAnimationExecutedWhenInlineCollapsed: boolean;
            inlineOpenKeys: any[];
        }, {
            sOpenKeys: (string | number)[];
        }, {}, {
            collapsedChange(val: unknown): void;
            restoreModeVerticalFromInline(): void;
            handleMouseEnter(e: Event): void;
            handleTransitionEnd(e: TransitionEvent): void;
            handleClick(e: Event): void;
            handleSelect(info: any): void;
            handleDeselect(info: any): void;
            handleOpenChange(openKeys: (string | number)[]): void;
            setOpenKeys(openKeys: (string | number)[]): void;
            getRealMenuMode(): string;
            getInlineCollapsed(): boolean;
            getMenuOpenAnimation(menuMode: string): string | {
                [key: string]: any;
            };
        }, {
            methods: {
                setState(state: {}, callback: any): void;
                __emit(...args: any[]): void;
            };
        }, import("vue").ComponentOptionsMixin, ("click" | "mouseenter" | "select" | "update:selectedKeys" | "update:openKeys" | "openChange" | "selectChange" | "deselect")[], string, {
            onClick: (...args: any[]) => any;
            onMouseenter: (...args: any[]) => any;
            onSelect: (...args: any[]) => any;
            prefixCls: string;
            visible: boolean;
            mode: string;
            getPopupContainer: (...args: any[]) => any;
            builtinPlacements: {
                [key: string]: any;
            };
            onDeselect: (...args: any[]) => any;
            focusable: boolean;
            isRootMenu: boolean;
            triggerSubMenuAction: string;
            forceSubMenuRender: boolean;
            subMenuOpenDelay: number;
            subMenuCloseDelay: number;
            level: number;
            inlineIndent: number;
            openTransitionName: string;
            theme: "dark" | "light";
            onOpenChange: (...args: any[]) => any;
            onSelectChange: (...args: any[]) => any;
        }>;
        $forceUpdate: import("vue").ReactiveEffect<any>;
        $nextTick: typeof import("vue").nextTick;
        $watch(source: string | Function, cb: Function, options?: import("vue").WatchOptions<boolean>): import("vue").WatchStopHandle;
    } & Readonly<{
        onClick: (...args: any[]) => any;
        onMouseenter: (...args: any[]) => any;
        onSelect: (...args: any[]) => any;
        prefixCls: string;
        visible: boolean;
        mode: string;
        getPopupContainer: (...args: any[]) => any;
        builtinPlacements: {
            [key: string]: any;
        };
        onDeselect: (...args: any[]) => any;
        focusable: boolean;
        isRootMenu: boolean;
        triggerSubMenuAction: string;
        forceSubMenuRender: boolean;
        subMenuOpenDelay: number;
        subMenuCloseDelay: number;
        level: number;
        inlineIndent: number;
        openTransitionName: string;
        theme: "dark" | "light";
        onOpenChange: (...args: any[]) => any;
        onSelectChange: (...args: any[]) => any;
    } & {
        multiple?: boolean;
        itemIcon?: any;
        expandIcon?: any;
        selectable?: boolean;
        openKeys?: (string | number)[];
        openAnimation?: string | {
            [key: string]: any;
        };
        selectedKeys?: (string | number)[];
        defaultSelectedKeys?: (string | number)[];
        defaultOpenKeys?: (string | number)[];
        inlineCollapsed?: boolean;
        activeKey?: string | number;
        overflowedIndicator?: any;
    }> & import("vue").ShallowUnwrapRef<{
        configProvider: import("../config-provider").ConfigConsumerProps;
        layoutSiderContext: SiderContextProps;
        layoutSiderCollapsed: import("vue").Ref<boolean>;
        propsUpdating: boolean;
        switchingModeFromInline: boolean;
        leaveAnimationExecutedWhenInlineCollapsed: boolean;
        inlineOpenKeys: any[];
    }> & {
        sOpenKeys: (string | number)[];
    } & {
        [x: string]: never;
    } & {
        setState(state: {}, callback: any): void;
        __emit(...args: any[]): void;
    } & {
        collapsedChange(val: unknown): void;
        restoreModeVerticalFromInline(): void;
        handleMouseEnter(e: Event): void;
        handleTransitionEnd(e: TransitionEvent): void;
        handleClick(e: Event): void;
        handleSelect(info: any): void;
        handleDeselect(info: any): void;
        handleOpenChange(openKeys: (string | number)[]): void;
        setOpenKeys(openKeys: (string | number)[]): void;
        getRealMenuMode(): string;
        getInlineCollapsed(): boolean;
        getMenuOpenAnimation(menuMode: string): string | {
            [key: string]: any;
        };
    } & import("vue").ComponentCustomProperties;
    __isFragment?: never;
    __isTeleport?: never;
    __isSuspense?: never;
} & import("vue").ComponentOptionsBase<Readonly<{
    onClick: (...args: any[]) => any;
    onMouseenter: (...args: any[]) => any;
    onSelect: (...args: any[]) => any;
    prefixCls: string;
    visible: boolean;
    mode: string;
    getPopupContainer: (...args: any[]) => any;
    builtinPlacements: {
        [key: string]: any;
    };
    onDeselect: (...args: any[]) => any;
    focusable: boolean;
    isRootMenu: boolean;
    triggerSubMenuAction: string;
    forceSubMenuRender: boolean;
    subMenuOpenDelay: number;
    subMenuCloseDelay: number;
    level: number;
    inlineIndent: number;
    openTransitionName: string;
    theme: "dark" | "light";
    onOpenChange: (...args: any[]) => any;
    onSelectChange: (...args: any[]) => any;
} & {
    multiple?: boolean;
    itemIcon?: any;
    expandIcon?: any;
    selectable?: boolean;
    openKeys?: (string | number)[];
    openAnimation?: string | {
        [key: string]: any;
    };
    selectedKeys?: (string | number)[];
    defaultSelectedKeys?: (string | number)[];
    defaultOpenKeys?: (string | number)[];
    inlineCollapsed?: boolean;
    activeKey?: string | number;
    overflowedIndicator?: any;
}>, {
    configProvider: import("../config-provider").ConfigConsumerProps;
    layoutSiderContext: SiderContextProps;
    layoutSiderCollapsed: import("vue").Ref<boolean>;
    propsUpdating: boolean;
    switchingModeFromInline: boolean;
    leaveAnimationExecutedWhenInlineCollapsed: boolean;
    inlineOpenKeys: any[];
}, {
    sOpenKeys: (string | number)[];
}, {}, {
    collapsedChange(val: unknown): void;
    restoreModeVerticalFromInline(): void;
    handleMouseEnter(e: Event): void;
    handleTransitionEnd(e: TransitionEvent): void;
    handleClick(e: Event): void;
    handleSelect(info: any): void;
    handleDeselect(info: any): void;
    handleOpenChange(openKeys: (string | number)[]): void;
    setOpenKeys(openKeys: (string | number)[]): void;
    getRealMenuMode(): string;
    getInlineCollapsed(): boolean;
    getMenuOpenAnimation(menuMode: string): string | {
        [key: string]: any;
    };
}, {
    methods: {
        setState(state: {}, callback: any): void;
        __emit(...args: any[]): void;
    };
}, import("vue").ComponentOptionsMixin, ("click" | "mouseenter" | "select" | "update:selectedKeys" | "update:openKeys" | "openChange" | "selectChange" | "deselect")[], "select" | "click" | "mouseenter" | "openChange" | "update:selectedKeys" | "update:openKeys" | "selectChange" | "deselect", {
    onClick: (...args: any[]) => any;
    onMouseenter: (...args: any[]) => any;
    onSelect: (...args: any[]) => any;
    prefixCls: string;
    visible: boolean;
    mode: string;
    getPopupContainer: (...args: any[]) => any;
    builtinPlacements: {
        [key: string]: any;
    };
    onDeselect: (...args: any[]) => any;
    focusable: boolean;
    isRootMenu: boolean;
    triggerSubMenuAction: string;
    forceSubMenuRender: boolean;
    subMenuOpenDelay: number;
    subMenuCloseDelay: number;
    level: number;
    inlineIndent: number;
    openTransitionName: string;
    theme: "dark" | "light";
    onOpenChange: (...args: any[]) => any;
    onSelectChange: (...args: any[]) => any;
}> & import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps & Plugin & {
    readonly Item: typeof Item;
    readonly SubMenu: typeof SubMenu;
    readonly Divider: typeof Divider;
    readonly ItemGroup: typeof ItemGroup;
};
export default _default;
