"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.menuProps = exports.MenuMode = void 0;

var _vue = require("vue");

var _omit = _interopRequireDefault(require("omit.js"));

var _vcMenu = _interopRequireWildcard(require("../vc-menu"));

var _SubMenu = _interopRequireDefault(require("./SubMenu"));

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _openAnimation = _interopRequireDefault(require("../_util/openAnimation"));

var _warning = _interopRequireDefault(require("../_util/warning"));

var _MenuItem = _interopRequireDefault(require("./MenuItem"));

var _propsUtil = require("../_util/props-util");

var _BaseMixin = _interopRequireDefault(require("../_util/BaseMixin"));

var _commonPropsType = _interopRequireDefault(require("../vc-menu/commonPropsType"));

var _configProvider = require("../config-provider");

var _type = require("../_util/type");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

// import raf from '../_util/raf';
var MenuMode = _vueTypes.default.oneOf(['vertical', 'vertical-left', 'vertical-right', 'horizontal', 'inline']);

exports.MenuMode = MenuMode;

var menuProps = _extends(_extends({}, _commonPropsType.default), {
  theme: _vueTypes.default.oneOf((0, _type.tuple)('light', 'dark')).def('light'),
  mode: MenuMode.def('vertical'),
  selectable: _vueTypes.default.looseBool,
  selectedKeys: _vueTypes.default.arrayOf(_vueTypes.default.oneOfType([_vueTypes.default.string, _vueTypes.default.number])),
  defaultSelectedKeys: _vueTypes.default.arrayOf(_vueTypes.default.oneOfType([_vueTypes.default.string, _vueTypes.default.number])),
  openKeys: _vueTypes.default.arrayOf(_vueTypes.default.oneOfType([_vueTypes.default.string, _vueTypes.default.number])),
  defaultOpenKeys: _vueTypes.default.arrayOf(_vueTypes.default.oneOfType([_vueTypes.default.string, _vueTypes.default.number])),
  openAnimation: _vueTypes.default.oneOfType([_vueTypes.default.string, _vueTypes.default.object]),
  openTransitionName: _vueTypes.default.string,
  prefixCls: _vueTypes.default.string,
  multiple: _vueTypes.default.looseBool,
  inlineIndent: _vueTypes.default.number.def(24),
  inlineCollapsed: _vueTypes.default.looseBool,
  isRootMenu: _vueTypes.default.looseBool.def(true),
  focusable: _vueTypes.default.looseBool.def(false),
  onOpenChange: _vueTypes.default.func,
  onSelect: _vueTypes.default.func,
  onDeselect: _vueTypes.default.func,
  onClick: _vueTypes.default.func,
  onMouseenter: _vueTypes.default.func,
  onSelectChange: _vueTypes.default.func
});

exports.menuProps = menuProps;
var Menu = (0, _vue.defineComponent)({
  name: 'AMenu',
  mixins: [_BaseMixin.default],
  inheritAttrs: false,
  props: menuProps,
  Divider: _extends(_extends({}, _vcMenu.Divider), {
    name: 'AMenuDivider'
  }),
  Item: _extends(_extends({}, _MenuItem.default), {
    name: 'AMenuItem'
  }),
  SubMenu: _extends(_extends({}, _SubMenu.default), {
    name: 'ASubMenu'
  }),
  ItemGroup: _extends(_extends({}, _vcMenu.ItemGroup), {
    name: 'AMenuItemGroup'
  }),
  emits: ['update:selectedKeys', 'update:openKeys', 'mouseenter', 'openChange', 'click', 'selectChange', 'select', 'deselect'],
  setup: function setup() {
    var layoutSiderContext = (0, _vue.inject)('layoutSiderContext', {});
    var layoutSiderCollapsed = (0, _vue.toRef)(layoutSiderContext, 'sCollapsed');
    return {
      configProvider: (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider),
      layoutSiderContext: layoutSiderContext,
      layoutSiderCollapsed: layoutSiderCollapsed,
      propsUpdating: false,
      switchingModeFromInline: false,
      leaveAnimationExecutedWhenInlineCollapsed: false,
      inlineOpenKeys: []
    };
  },
  data: function data() {
    var props = (0, _propsUtil.getOptionProps)(this);
    (0, _warning.default)(!('inlineCollapsed' in props && props.mode !== 'inline'), 'Menu', "`inlineCollapsed` should only be used when Menu's `mode` is inline.");
    var sOpenKeys;

    if ('openKeys' in props) {
      sOpenKeys = props.openKeys;
    } else if ('defaultOpenKeys' in props) {
      sOpenKeys = props.defaultOpenKeys;
    }

    return {
      sOpenKeys: sOpenKeys
    };
  },
  // beforeUnmount() {
  //   raf.cancel(this.mountRafId);
  // },
  watch: {
    mode: function mode(val, oldVal) {
      if (oldVal === 'inline' && val !== 'inline') {
        this.switchingModeFromInline = true;
      }
    },
    openKeys: function openKeys(val) {
      this.setState({
        sOpenKeys: val
      });
    },
    inlineCollapsed: function inlineCollapsed(val) {
      this.collapsedChange(val);
    },
    layoutSiderCollapsed: function layoutSiderCollapsed(val) {
      this.collapsedChange(val);
    }
  },
  created: function created() {
    (0, _vue.provide)('getInlineCollapsed', this.getInlineCollapsed);
    (0, _vue.provide)('menuPropsContext', this.$props);
  },
  updated: function updated() {
    this.propsUpdating = false;
  },
  methods: {
    collapsedChange: function collapsedChange(val) {
      if (this.propsUpdating) {
        return;
      }

      this.propsUpdating = true;

      if (!(0, _propsUtil.hasProp)(this, 'openKeys')) {
        if (val) {
          this.switchingModeFromInline = true;
          this.inlineOpenKeys = this.sOpenKeys;
          this.setState({
            sOpenKeys: []
          });
        } else {
          this.setState({
            sOpenKeys: this.inlineOpenKeys
          });
          this.inlineOpenKeys = [];
        }
      } else if (val) {
        // 缩起时，openKeys置为空的动画会闪动，react可以通过是否传递openKeys避免闪动，vue不是很方便动态传递openKeys
        this.switchingModeFromInline = true;
      }
    },
    restoreModeVerticalFromInline: function restoreModeVerticalFromInline() {
      if (this.switchingModeFromInline) {
        this.switchingModeFromInline = false;
        this.$forceUpdate();
      }
    },
    // Restore vertical mode when menu is collapsed responsively when mounted
    // https://github.com/ant-design/ant-design/issues/13104
    // TODO: not a perfect solution, looking a new way to avoid setting switchingModeFromInline in this situation
    handleMouseEnter: function handleMouseEnter(e) {
      this.restoreModeVerticalFromInline();
      this.$emit('mouseenter', e);
    },
    handleTransitionEnd: function handleTransitionEnd(e) {
      // when inlineCollapsed menu width animation finished
      // https://github.com/ant-design/ant-design/issues/12864
      var widthCollapsed = e.propertyName === 'width' && e.target === e.currentTarget; // Fix SVGElement e.target.className.indexOf is not a function
      // https://github.com/ant-design/ant-design/issues/15699

      var className = e.target.className; // SVGAnimatedString.animVal should be identical to SVGAnimatedString.baseVal, unless during an animation.

      var classNameValue = Object.prototype.toString.call(className) === '[object SVGAnimatedString]' ? className.animVal : className; // Fix for <Menu style={{ width: '100%' }} />, the width transition won't trigger when menu is collapsed
      // https://github.com/ant-design/ant-design-pro/issues/2783

      var iconScaled = e.propertyName === 'font-size' && classNameValue.indexOf('anticon') >= 0;

      if (widthCollapsed || iconScaled) {
        this.restoreModeVerticalFromInline();
      }
    },
    handleClick: function handleClick(e) {
      this.handleOpenChange([]);
      this.$emit('click', e);
    },
    handleSelect: function handleSelect(info) {
      this.$emit('update:selectedKeys', info.selectedKeys);
      this.$emit('select', info);
      this.$emit('selectChange', info.selectedKeys);
    },
    handleDeselect: function handleDeselect(info) {
      this.$emit('update:selectedKeys', info.selectedKeys);
      this.$emit('deselect', info);
      this.$emit('selectChange', info.selectedKeys);
    },
    handleOpenChange: function handleOpenChange(openKeys) {
      this.setOpenKeys(openKeys);
      this.$emit('update:openKeys', openKeys);
      this.$emit('openChange', openKeys);
    },
    setOpenKeys: function setOpenKeys(openKeys) {
      if (!(0, _propsUtil.hasProp)(this, 'openKeys')) {
        this.setState({
          sOpenKeys: openKeys
        });
      }
    },
    getRealMenuMode: function getRealMenuMode() {
      var inlineCollapsed = this.getInlineCollapsed();

      if (this.switchingModeFromInline && inlineCollapsed) {
        return 'inline';
      }

      var mode = this.$props.mode;
      return inlineCollapsed ? 'vertical' : mode;
    },
    getInlineCollapsed: function getInlineCollapsed() {
      var inlineCollapsed = this.$props.inlineCollapsed;

      if (this.layoutSiderContext.sCollapsed !== undefined) {
        return this.layoutSiderContext.sCollapsed;
      }

      return inlineCollapsed;
    },
    getMenuOpenAnimation: function getMenuOpenAnimation(menuMode) {
      var _this$$props = this.$props,
          openAnimation = _this$$props.openAnimation,
          openTransitionName = _this$$props.openTransitionName;
      var menuOpenAnimation = openAnimation || openTransitionName;

      if (openAnimation === undefined && openTransitionName === undefined) {
        if (menuMode === 'horizontal') {
          menuOpenAnimation = 'slide-up';
        } else if (menuMode === 'inline') {
          menuOpenAnimation = _openAnimation.default;
        } else {
          // When mode switch from inline
          // submenu should hide without animation
          if (this.switchingModeFromInline) {
            menuOpenAnimation = '';
            this.switchingModeFromInline = false;
          } else {
            menuOpenAnimation = 'zoom-big';
          }
        }
      }

      return menuOpenAnimation;
    }
  },
  render: function render() {
    var _menuClassName,
        _this = this;

    var layoutSiderContext = this.layoutSiderContext;
    var collapsedWidth = layoutSiderContext.collapsedWidth;
    var getContextPopupContainer = this.configProvider.getPopupContainer;
    var props = (0, _propsUtil.getOptionProps)(this);
    var customizePrefixCls = props.prefixCls,
        theme = props.theme,
        getPopupContainer = props.getPopupContainer;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('menu', customizePrefixCls);
    var menuMode = this.getRealMenuMode();
    var menuOpenAnimation = this.getMenuOpenAnimation(menuMode);

    var _a = this.$attrs,
        className = _a.class,
        otherAttrs = __rest(_a, ["class"]);

    var menuClassName = (_menuClassName = {}, _defineProperty(_menuClassName, className, className), _defineProperty(_menuClassName, "".concat(prefixCls, "-").concat(theme), true), _defineProperty(_menuClassName, "".concat(prefixCls, "-inline-collapsed"), this.getInlineCollapsed()), _menuClassName);

    var menuProps = _extends(_extends(_extends(_extends({}, (0, _omit.default)(props, ['inlineCollapsed', 'onUpdate:selectedKeys', 'onUpdate:openKeys', 'onSelectChange'])), {
      getPopupContainer: getPopupContainer || getContextPopupContainer,
      openKeys: this.sOpenKeys,
      mode: menuMode,
      prefixCls: prefixCls
    }), otherAttrs), {
      onSelect: this.handleSelect,
      onDeselect: this.handleDeselect,
      onOpenChange: this.handleOpenChange,
      onMouseenter: this.handleMouseEnter,
      onTransitionend: this.handleTransitionEnd
    });

    if (!(0, _propsUtil.hasProp)(this, 'selectedKeys')) {
      delete menuProps.selectedKeys;
    }

    if (menuMode !== 'inline') {
      // closing vertical popup submenu after click it
      menuProps.onClick = this.handleClick;
      menuProps.openTransitionName = menuOpenAnimation;
    } else {
      menuProps.onClick = function (e) {
        _this.$emit('click', e);
      };

      menuProps.openAnimation = menuOpenAnimation;
    } // https://github.com/ant-design/ant-design/issues/8587


    var hideMenu = this.getInlineCollapsed() && (collapsedWidth === 0 || collapsedWidth === '0' || collapsedWidth === '0px');

    if (hideMenu) {
      menuProps.openKeys = [];
    }

    return (0, _vue.createVNode)(_vcMenu.default, _objectSpread(_objectSpread({}, menuProps), {}, {
      "class": menuClassName
    }), this.$slots);
  }
});
/* istanbul ignore next */

Menu.install = function (app) {
  app.component(Menu.name, Menu);
  app.component(Menu.Item.name, Menu.Item);
  app.component(Menu.SubMenu.name, Menu.SubMenu);
  app.component(Menu.Divider.name, Menu.Divider);
  app.component(Menu.ItemGroup.name, Menu.ItemGroup);
  return app;
};

var _default = Menu;
exports.default = _default;