"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.PageHeaderProps = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _propsUtil = require("../_util/props-util");

var _configProvider = require("../config-provider");

var _ArrowLeftOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/ArrowLeftOutlined"));

var _breadcrumb = _interopRequireDefault(require("../breadcrumb"));

var _avatar = _interopRequireDefault(require("../avatar"));

var _transButton = _interopRequireDefault(require("../_util/transButton"));

var _LocaleReceiver = _interopRequireDefault(require("../locale-provider/LocaleReceiver"));

var _type = require("../_util/type");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var PageHeaderProps = {
  backIcon: _vueTypes.default.VNodeChild,
  prefixCls: _vueTypes.default.string,
  title: _vueTypes.default.VNodeChild,
  subTitle: _vueTypes.default.VNodeChild,
  breadcrumb: _vueTypes.default.object,
  tags: _vueTypes.default.any,
  footer: _vueTypes.default.VNodeChild,
  extra: _vueTypes.default.VNodeChild,
  avatar: _vueTypes.default.object,
  ghost: _vueTypes.default.looseBool,
  onBack: _vueTypes.default.func
};
exports.PageHeaderProps = PageHeaderProps;

var renderBack = function renderBack(instance, prefixCls, backIcon, onBack) {
  if (!backIcon || !onBack) {
    return null;
  }

  return (0, _vue.createVNode)(_LocaleReceiver.default, {
    "componentName": "PageHeader",
    "children": function children(_ref) {
      var back = _ref.back;
      return (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls, "-back")
      }, [(0, _vue.createVNode)(_transButton.default, {
        "onClick": function onClick(e) {
          instance.$emit('back', e);
        },
        "class": "".concat(prefixCls, "-back-button"),
        "aria-label": back
      }, {
        default: function _default() {
          return [backIcon];
        }
      })]);
    }
  }, null);
};

var renderBreadcrumb = function renderBreadcrumb(breadcrumb) {
  return (0, _vue.createVNode)(_breadcrumb.default, breadcrumb, null);
};

var renderTitle = function renderTitle(prefixCls, instance) {
  var avatar = instance.avatar;
  var title = (0, _propsUtil.getComponent)(instance, 'title');
  var subTitle = (0, _propsUtil.getComponent)(instance, 'subTitle');
  var tags = (0, _propsUtil.getComponent)(instance, 'tags');
  var extra = (0, _propsUtil.getComponent)(instance, 'extra');
  var backIcon = (0, _propsUtil.getComponent)(instance, 'backIcon') !== undefined ? (0, _propsUtil.getComponent)(instance, 'backIcon') : (0, _vue.createVNode)(_ArrowLeftOutlined.default, null, null);
  var onBack = instance.onBack;
  var headingPrefixCls = "".concat(prefixCls, "-heading");

  if (title || subTitle || tags || extra) {
    var backIconDom = renderBack(instance, prefixCls, backIcon, onBack);
    return (0, _vue.createVNode)("div", {
      "class": headingPrefixCls
    }, [backIconDom, avatar && (0, _vue.createVNode)(_avatar.default, avatar, null), title && (0, _vue.createVNode)("span", {
      "class": "".concat(headingPrefixCls, "-title")
    }, [title]), subTitle && (0, _vue.createVNode)("span", {
      "class": "".concat(headingPrefixCls, "-sub-title")
    }, [subTitle]), tags && (0, _vue.createVNode)("span", {
      "class": "".concat(headingPrefixCls, "-tags")
    }, [tags]), extra && (0, _vue.createVNode)("span", {
      "class": "".concat(headingPrefixCls, "-extra")
    }, [extra])]);
  }

  return null;
};

var renderFooter = function renderFooter(prefixCls, footer) {
  if (footer) {
    return (0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, "-footer")
    }, [footer]);
  }

  return null;
};

var renderChildren = function renderChildren(prefixCls, children) {
  return (0, _vue.createVNode)("div", {
    "class": "".concat(prefixCls, "-content")
  }, [children]);
};

var PageHeader = (0, _vue.defineComponent)({
  name: 'APageHeader',
  props: PageHeaderProps,
  setup: function setup() {
    return {
      configProvider: (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider)
    };
  },
  render: function render() {
    var _this$configProvider = this.configProvider,
        getPrefixCls = _this$configProvider.getPrefixCls,
        pageHeader = _this$configProvider.pageHeader;
    var props = (0, _propsUtil.getOptionProps)(this);
    var customizePrefixCls = props.prefixCls,
        breadcrumb = props.breadcrumb;
    var footer = (0, _propsUtil.getComponent)(this, 'footer');
    var children = (0, _propsUtil.getSlot)(this);
    var ghost = true; // Use `ghost` from `props` or from `ConfigProvider` instead.

    if ('ghost' in props) {
      ghost = props.ghost;
    } else if (pageHeader && 'ghost' in pageHeader) {
      ghost = pageHeader.ghost;
    }

    var prefixCls = getPrefixCls('page-header', customizePrefixCls);
    var breadcrumbDom = breadcrumb && breadcrumb.routes ? renderBreadcrumb(breadcrumb) : null;
    var className = [prefixCls, _defineProperty({
      'has-breadcrumb': breadcrumbDom,
      'has-footer': footer
    }, "".concat(prefixCls, "-ghost"), ghost)];
    return (0, _vue.createVNode)("div", {
      "class": className
    }, [breadcrumbDom, renderTitle(prefixCls, this), children.length ? renderChildren(prefixCls, children) : null, renderFooter(prefixCls, footer)]);
  }
});

var _default2 = (0, _type.withInstall)(PageHeader);

exports.default = _default2;