"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RateProps = void 0;

var _vue = require("vue");

var _omit = _interopRequireDefault(require("omit.js"));

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _propsUtil = require("../_util/props-util");

var _configProvider = require("../config-provider");

var _vcRate = _interopRequireDefault(require("../vc-rate"));

var _StarFilled = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/StarFilled"));

var _tooltip = _interopRequireDefault(require("../tooltip"));

var _type = require("../_util/type");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

var RateProps = {
  prefixCls: _vueTypes.default.string,
  count: _vueTypes.default.number,
  value: _vueTypes.default.number,
  defaultValue: _vueTypes.default.number,
  allowHalf: _vueTypes.default.looseBool,
  allowClear: _vueTypes.default.looseBool,
  tooltips: _vueTypes.default.arrayOf(_vueTypes.default.string),
  disabled: _vueTypes.default.looseBool,
  character: _vueTypes.default.any,
  autofocus: _vueTypes.default.looseBool
};
exports.RateProps = RateProps;
var Rate = (0, _vue.defineComponent)({
  name: 'ARate',
  props: RateProps,
  setup: function setup() {
    return {
      configProvider: (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider)
    };
  },
  methods: {
    characterRender: function characterRender(node, _ref) {
      var index = _ref.index;
      var tooltips = this.$props.tooltips;
      if (!tooltips) return node;
      return (0, _vue.createVNode)(_tooltip.default, {
        "title": tooltips[index]
      }, {
        default: function _default() {
          return [node];
        }
      });
    },
    focus: function focus() {
      this.$refs.refRate.focus();
    },
    blur: function blur() {
      this.$refs.refRate.blur();
    }
  },
  render: function render() {
    var _a = (0, _propsUtil.getOptionProps)(this),
        customizePrefixCls = _a.prefixCls,
        restProps = __rest(_a, ["prefixCls"]);

    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('rate', customizePrefixCls);
    var character = (0, _propsUtil.getComponent)(this, 'character') || (0, _vue.createVNode)(_StarFilled.default, null, null);

    var rateProps = _extends(_extends(_extends({
      character: character,
      characterRender: this.characterRender,
      prefixCls: prefixCls
    }, (0, _omit.default)(restProps, ['tooltips'])), this.$attrs), {
      ref: 'refRate'
    });

    return (0, _vue.createVNode)(_vcRate.default, rateProps, null);
  }
});

var _default2 = (0, _type.withInstall)(Rate);

exports.default = _default2;