"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ResultProps = exports.ExceptionMap = exports.IconMap = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _type = require("../_util/type");

var _propsUtil = require("../_util/props-util");

var _configProvider = require("../config-provider");

var _CheckCircleFilled = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/CheckCircleFilled"));

var _CloseCircleFilled = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/CloseCircleFilled"));

var _ExclamationCircleFilled = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/ExclamationCircleFilled"));

var _WarningFilled = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/WarningFilled"));

var _noFound = _interopRequireDefault(require("./noFound"));

var _serverError = _interopRequireDefault(require("./serverError"));

var _unauthorized = _interopRequireDefault(require("./unauthorized"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var IconMap = {
  success: _CheckCircleFilled.default,
  error: _CloseCircleFilled.default,
  info: _ExclamationCircleFilled.default,
  warning: _WarningFilled.default
};
exports.IconMap = IconMap;
var ExceptionMap = {
  '404': _noFound.default,
  '500': _serverError.default,
  '403': _unauthorized.default
}; // ExceptionImageMap keys

exports.ExceptionMap = ExceptionMap;
var ExceptionStatus = Object.keys(ExceptionMap);
var ResultProps = {
  prefixCls: _vueTypes.default.string,
  icon: _vueTypes.default.any,
  status: _vueTypes.default.oneOf((0, _type.tuple)('success', 'error', 'info', 'warning', '404', '403', '500')).def('info'),
  title: _vueTypes.default.any,
  subTitle: _vueTypes.default.any,
  extra: _vueTypes.default.any
};
exports.ResultProps = ResultProps;

var renderIcon = function renderIcon(prefixCls, _ref) {
  var status = _ref.status,
      icon = _ref.icon;

  if (ExceptionStatus.includes("".concat(status))) {
    var SVGComponent = ExceptionMap[status];
    return (0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, "-icon ").concat(prefixCls, "-image")
    }, [(0, _vue.createVNode)(SVGComponent, null, null)]);
  }

  var IconComponent = IconMap[status];
  var iconNode = icon || (0, _vue.createVNode)(IconComponent, null, null);
  return (0, _vue.createVNode)("div", {
    "class": "".concat(prefixCls, "-icon")
  }, [iconNode]);
};

var renderExtra = function renderExtra(prefixCls, extra) {
  return extra && (0, _vue.createVNode)("div", {
    "class": "".concat(prefixCls, "-extra")
  }, [extra]);
};

var Result = (0, _vue.defineComponent)({
  name: 'AResult',
  props: ResultProps,
  setup: function setup() {
    return {
      configProvider: (0, _vue.inject)('configProvider', _configProvider.defaultConfigProvider)
    };
  },
  render: function render() {
    var customizePrefixCls = this.prefixCls,
        status = this.status;
    var getPrefixCls = this.configProvider.getPrefixCls;
    var prefixCls = getPrefixCls('result', customizePrefixCls);
    var title = (0, _propsUtil.getComponent)(this, 'title');
    var subTitle = (0, _propsUtil.getComponent)(this, 'subTitle');
    var icon = (0, _propsUtil.getComponent)(this, 'icon');
    var extra = (0, _propsUtil.getComponent)(this, 'extra');
    return (0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, " ").concat(prefixCls, "-").concat(status)
    }, [renderIcon(prefixCls, {
      status: status,
      icon: icon
    }), (0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, "-title")
    }, [title]), subTitle && (0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, "-subtitle")
    }, [subTitle]), this.$slots.default && (0, _vue.createVNode)("div", {
      "class": "".concat(prefixCls, "-content")
    }, [this.$slots.default()]), renderExtra(prefixCls, extra)]);
  }
});
/* add resource */

Result.PRESENTED_IMAGE_403 = ExceptionMap[403];
Result.PRESENTED_IMAGE_404 = ExceptionMap[404];
Result.PRESENTED_IMAGE_500 = ExceptionMap[500];
/* istanbul ignore next */

Result.install = function (app) {
  app.component(Result.name, Result);
  return app;
};

var _default = Result;
exports.default = _default;