"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SkeletonAvatarProps = void 0;

var _vue = require("vue");

var _classNames3 = _interopRequireDefault(require("../_util/classNames"));

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _type = require("../_util/type");

var _initDefaultProps = _interopRequireDefault(require("../_util/props-util/initDefaultProps"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var skeletonAvatarProps = {
  prefixCls: _vueTypes.default.string,
  size: _vueTypes.default.oneOfType([_vueTypes.default.oneOf((0, _type.tuple)('large', 'small', 'default')), _vueTypes.default.number]),
  shape: _vueTypes.default.oneOf((0, _type.tuple)('circle', 'square'))
};

var SkeletonAvatarProps = _vueTypes.default.shape(skeletonAvatarProps).loose;

exports.SkeletonAvatarProps = SkeletonAvatarProps;
var Avatar = (0, _vue.defineComponent)({
  props: (0, _initDefaultProps.default)(skeletonAvatarProps, {
    size: 'large'
  }),
  render: function render() {
    var _classNames, _classNames2;

    var _this$$props = this.$props,
        prefixCls = _this$$props.prefixCls,
        size = _this$$props.size,
        shape = _this$$props.shape;
    var sizeCls = (0, _classNames3.default)((_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-lg"), size === 'large'), _defineProperty(_classNames, "".concat(prefixCls, "-sm"), size === 'small'), _classNames));
    var shapeCls = (0, _classNames3.default)((_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefixCls, "-circle"), shape === 'circle'), _defineProperty(_classNames2, "".concat(prefixCls, "-square"), shape === 'square'), _classNames2));
    var sizeStyle = typeof size === 'number' ? {
      width: "".concat(size, "px"),
      height: "".concat(size, "px"),
      lineHeight: "".concat(size, "px")
    } : {};
    return (0, _vue.createVNode)("span", {
      "class": (0, _classNames3.default)(prefixCls, sizeCls, shapeCls),
      "style": sizeStyle
    }, null);
  }
});
var _default = Avatar;
exports.default = _default;