"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _domAlign = require("dom-align");

var _addEventListener = _interopRequireDefault(require("../vc-util/Dom/addEventListener"));

var _util = require("./util");

var _vnode = require("../_util/vnode");

var _propsUtil = require("../_util/props-util");

var _useBuffer3 = _interopRequireDefault(require("./hooks/useBuffer"));

var _isVisible = _interopRequireDefault(require("../vc-util/Dom/isVisible"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function getElement(func) {
  if (typeof func !== 'function' || !func) return null;
  return func();
}

function getPoint(point) {
  if (_typeof(point) !== 'object' || !point) return null;
  return point;
}

var _default = (0, _vue.defineComponent)({
  props: {
    childrenProps: _vueTypes.default.object,
    align: _vueTypes.default.object.isRequired,
    target: _vueTypes.default.oneOfType([_vueTypes.default.func, _vueTypes.default.object]).def(function () {
      return window;
    }),
    monitorBufferTime: _vueTypes.default.number.def(50),
    monitorWindowResize: _vueTypes.default.looseBool.def(false),
    disabled: _vueTypes.default.looseBool.def(false)
  },
  setup: function setup() {
    return {
      aligned: false,
      sourceResizeMonitor: {
        cancel: function cancel() {}
      },
      resizeMonitor: {
        cancel: function cancel() {}
      },
      cacheInfo: {}
    };
  },
  data: function data() {
    this.prevProps = _extends({}, this.$props);

    var _useBuffer = (0, _useBuffer3.default)(this.goAlign, 0),
        _useBuffer2 = _slicedToArray(_useBuffer, 2),
        forceAlign = _useBuffer2[0],
        cancelForceAlign = _useBuffer2[1];

    return {
      forceAlign: forceAlign,
      cancelForceAlign: cancelForceAlign
    };
  },
  mounted: function mounted() {
    var _this = this;

    (0, _vue.nextTick)(function () {
      var props = _this.$props; // if parent ref not attached .... use document.getElementById

      !_this.aligned && _this.forceAlign();

      if (!props.disabled && props.monitorWindowResize) {
        _this.startMonitorWindowResize();
      }

      _this.startMonitorElementResize();

      _this.updateCache();
    });
  },
  updated: function updated() {
    var _this2 = this;

    (0, _vue.nextTick)(function () {
      var prevProps = _this2.prevProps;
      var props = _this2.$props;
      var reAlign = false;

      if (!props.disabled) {
        if (prevProps.disabled) {
          reAlign = true;
        } else {
          var _this2$cacheInfo = _this2.cacheInfo,
              lastElement = _this2$cacheInfo.element,
              lastPoint = _this2$cacheInfo.point;
          var currentElement = getElement(props.target);
          var currentPoint = getPoint(props.target);

          if ((0, _util.isWindow)(lastElement) && (0, _util.isWindow)(currentElement)) {
            // Skip if is window
            reAlign = false;
          } else if (lastElement && !currentElement && currentPoint || // Change from element to point
          lastPoint && currentPoint && currentElement // Change from point to element
          ) {
              reAlign = true;
            }
        }
      }

      if (reAlign) {
        _this2.forceAlign();
      } else {
        _this2.startMonitorElementResize();
      }

      if (props.monitorWindowResize && !props.disabled) {
        _this2.startMonitorWindowResize();
      } else {
        _this2.stopMonitorWindowResize();
      }

      _this2.prevProps = _extends({}, _this2.$props);

      _this2.updateCache();
    });
  },
  beforeUnmount: function beforeUnmount() {
    var _a, _b;

    this.stopMonitorWindowResize();
    (_a = this.resizeMonitor) === null || _a === void 0 ? void 0 : _a.cancel();
    (_b = this.sourceResizeMonitor) === null || _b === void 0 ? void 0 : _b.cancel();
    this.cancelForceAlign();
  },
  methods: {
    updateCache: function updateCache() {
      var element = getElement(this.$props.target);
      var point = getPoint(this.$props.target);
      this.cacheInfo = {
        element: element,
        point: point
      };
    },
    startMonitorElementResize: function startMonitorElementResize() {
      var props = this.$props;
      var _this$cacheInfo = this.cacheInfo,
          lastElement = _this$cacheInfo.element,
          lastPoint = _this$cacheInfo.point;
      var currentElement = getElement(props.target);
      var currentPoint = getPoint(props.target);
      var source = (0, _propsUtil.findDOMNode)(this);
      var sourceResizeMonitor = this.sourceResizeMonitor,
          resizeMonitor = this.resizeMonitor;

      if (source !== sourceResizeMonitor.element) {
        sourceResizeMonitor === null || sourceResizeMonitor === void 0 ? void 0 : sourceResizeMonitor.cancel();
        sourceResizeMonitor.element = source;
        sourceResizeMonitor.cancel = (0, _util.monitorResize)(source, this.forceAlign);
      }

      if (lastElement !== currentElement || !(0, _util.isSamePoint)(lastPoint, currentPoint)) {
        this.forceAlign(); // Add resize observer

        if (resizeMonitor.element !== currentElement) {
          resizeMonitor === null || resizeMonitor === void 0 ? void 0 : resizeMonitor.cancel();
          resizeMonitor.element = currentElement;
          resizeMonitor.cancel = (0, _util.monitorResize)(currentElement, this.forceAlign);
        }
      }
    },
    startMonitorWindowResize: function startMonitorWindowResize() {
      if (!this.resizeHandler) {
        this.bufferMonitor = (0, _util.buffer)(this.forceAlign, this.$props.monitorBufferTime);
        this.resizeHandler = (0, _addEventListener.default)(window, 'resize', this.bufferMonitor);
      }
    },
    stopMonitorWindowResize: function stopMonitorWindowResize() {
      if (this.resizeHandler) {
        this.bufferMonitor.clear();
        this.resizeHandler.remove();
        this.resizeHandler = null;
      }
    },
    goAlign: function goAlign() {
      var _this$$props = this.$props,
          disabled = _this$$props.disabled,
          target = _this$$props.target,
          align = _this$$props.align;

      if (!disabled && target) {
        var source = (0, _propsUtil.findDOMNode)(this);
        var result;
        var element = getElement(target);
        var point = getPoint(target); // IE lose focus after element realign
        // We should record activeElement and restore later

        var activeElement = document.activeElement;

        if (element && (0, _isVisible.default)(element)) {
          result = (0, _domAlign.alignElement)(source, element, align);
        } else if (point) {
          result = (0, _domAlign.alignPoint)(source, point, align);
        }

        (0, _util.restoreFocus)(activeElement, source);
        this.aligned = true;
        this.$attrs.onAlign && result && this.$attrs.onAlign(source, result);
        return true;
      }

      return false;
    }
  },
  render: function render() {
    var childrenProps = this.$props.childrenProps;
    var child = (0, _propsUtil.getSlot)(this);

    if (child && childrenProps) {
      return (0, _vnode.cloneElement)(child[0], childrenProps);
    }

    return child && child[0];
  }
});

exports.default = _default;