"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _default = function _default(callback, buffer) {
  var called = false;
  var timeout = null;

  function cancelTrigger() {
    window.clearTimeout(timeout);
  }

  function trigger(force) {
    if (!called || force === true) {
      if (callback() === false) {
        // Not delay since callback cancelled self
        return;
      }

      called = true;
      cancelTrigger();
      timeout = window.setTimeout(function () {
        called = false;
      }, buffer);
    } else {
      cancelTrigger();
      timeout = window.setTimeout(function () {
        called = false;
        trigger();
      }, buffer);
    }
  }

  return [trigger, function () {
    called = false;
    cancelTrigger();
  }];
};

exports.default = _default;