"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _vue = require("vue");

var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));

var _SubPopupMenu = _interopRequireDefault(require("./SubPopupMenu"));

var _BaseMixin = _interopRequireDefault(require("../_util/BaseMixin"));

var _propsUtil = _interopRequireWildcard(require("../_util/props-util"));

var _commonPropsType = _interopRequireDefault(require("./commonPropsType"));

var _isEqual = _interopRequireDefault(require("lodash/isEqual"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var Menu = {
  name: 'Menu',
  inheritAttrs: false,
  props: _extends(_extends({}, _commonPropsType.default), {
    onClick: _vueTypes.default.func,
    selectable: _vueTypes.default.looseBool.def(true)
  }),
  mixins: [_BaseMixin.default],
  setup: function setup(props) {
    var menuChildrenInfo = (0, _vue.reactive)({});
    var selectedKeys = (0, _vue.ref)(props.selectedKeys || props.defaultSelectedKeys || []);
    var openKeys = (0, _vue.ref)(props.openKeys || props.defaultOpenKeys || []); //  computed(() => {
    //   return props.openKeys || props.defaultOpenKeys || [];
    // });

    (0, _vue.watch)(function () {
      return props.selectedKeys;
    }, function () {
      selectedKeys.value = props.selectedKeys || [];
    });
    (0, _vue.watch)(function () {
      return props.openKeys;
    }, function () {
      openKeys.value = props.openKeys || [];
    });
    var activeKey = (0, _vue.reactive)({
      '0-menu-': props.activeKey
    });
    var defaultActiveFirst = (0, _vue.reactive)({});

    var addChildrenInfo = function addChildrenInfo(key, info) {
      menuChildrenInfo[key] = info;
    };

    var removeChildrenInfo = function removeChildrenInfo(key) {
      delete menuChildrenInfo[key];
    };

    var getActiveKey = function getActiveKey(key) {
      return key;
    }; // TODO


    var selectedParentUniKeys = (0, _vue.ref)([]);
    (0, _vue.watch)(menuChildrenInfo, function () {
      var keys = Object.values(menuChildrenInfo).filter(function (info) {
        return info.isSelected;
      }).reduce(function (allKeys, _ref) {
        var _ref$parentUniKeys = _ref.parentUniKeys,
            parentUniKeys = _ref$parentUniKeys === void 0 ? [] : _ref$parentUniKeys;
        return [].concat(_toConsumableArray(allKeys), _toConsumableArray((0, _vue.toRaw)(parentUniKeys)));
      }, []);

      if (!(0, _isEqual.default)(selectedParentUniKeys.value, keys)) {
        selectedParentUniKeys.value = keys || [];
      }
    });
    var store = (0, _vue.reactive)({
      selectedKeys: selectedKeys,
      openKeys: openKeys,
      activeKey: activeKey,
      defaultActiveFirst: defaultActiveFirst,
      menuChildrenInfo: menuChildrenInfo,
      selectedParentUniKeys: selectedParentUniKeys,
      addChildrenInfo: addChildrenInfo,
      removeChildrenInfo: removeChildrenInfo,
      getActiveKey: getActiveKey
    });
    var ins = (0, _vue.getCurrentInstance)();

    var getEl = function getEl() {
      return ins.vnode.el;
    };

    (0, _vue.provide)('menuStore', store);
    (0, _vue.provide)('parentMenu', (0, _vue.reactive)({
      isRootMenu: (0, _vue.computed)(function () {
        return props.isRootMenu;
      }),
      getPopupContainer: (0, _vue.computed)(function () {
        return props.getPopupContainer;
      }),
      getEl: getEl
    }));
    return {
      store: store
    };
  },
  methods: {
    handleSelect: function handleSelect(selectInfo) {
      var props = this.$props;

      if (props.selectable) {
        // root menu
        var selectedKeys = this.store.selectedKeys;
        var selectedKey = selectInfo.key;

        if (props.multiple) {
          selectedKeys = selectedKeys.concat([selectedKey]);
        } else {
          selectedKeys = [selectedKey];
        }

        if (!(0, _propsUtil.default)(this, 'selectedKeys')) {
          this.store.selectedKeys = selectedKeys;
        }

        this.__emit('select', _extends(_extends({}, selectInfo), {
          selectedKeys: selectedKeys
        }));
      }
    },
    handleClick: function handleClick(e) {
      this.__emit('click', e);
    },
    // onKeyDown needs to be exposed as a instance method
    // e.g., in rc-select, we need to navigate menu item while
    // current active item is rc-select input box rather than the menu itself
    onKeyDown: function onKeyDown(e, callback) {
      this.innerMenu.getWrappedInstance().onKeyDown(e, callback);
    },
    onOpenChange: function onOpenChange(event) {
      var openKeys = this.store.openKeys.concat();
      var changed = false;

      var processSingle = function processSingle(e) {
        var oneChanged = false;

        if (e.open) {
          oneChanged = openKeys.indexOf(e.key) === -1;

          if (oneChanged) {
            openKeys.push(e.key);
          }
        } else {
          var index = openKeys.indexOf(e.key);
          oneChanged = index !== -1;

          if (oneChanged) {
            openKeys.splice(index, 1);
          }
        }

        changed = changed || oneChanged;
      };

      if (Array.isArray(event)) {
        // batch change call
        event.forEach(processSingle);
      } else {
        processSingle(event);
      }

      if (changed) {
        if (!(0, _propsUtil.default)(this, 'openKeys')) {
          this.store.openKeys = openKeys;
        }

        this.__emit('openChange', openKeys);
      }
    },
    handleDeselect: function handleDeselect(selectInfo) {
      var props = this.$props;

      if (props.selectable) {
        var selectedKeys = this.store.selectedKeys.concat();
        var selectedKey = selectInfo.key;
        var index = selectedKeys.indexOf(selectedKey);

        if (index !== -1) {
          selectedKeys.splice(index, 1);
        }

        if (!(0, _propsUtil.default)(this, 'selectedKeys')) {
          this.store.selectedKeys = selectedKeys;
        }

        this.__emit('deselect', _extends(_extends({}, selectInfo), {
          selectedKeys: selectedKeys
        }));
      }
    },
    getOpenTransitionName: function getOpenTransitionName() {
      var props = this.$props;
      var transitionName = props.openTransitionName;
      var animationName = props.openAnimation;

      if (!transitionName && typeof animationName === 'string') {
        transitionName = "".concat(props.prefixCls, "-open-").concat(animationName);
      }

      return transitionName;
    },
    saveInnerMenu: function saveInnerMenu(ref) {
      this.innerMenu = ref;
    }
  },
  render: function render() {
    var props = _extends(_extends({}, (0, _propsUtil.getOptionProps)(this)), this.$attrs);

    props.class = props.class ? "".concat(props.class, " ").concat(props.prefixCls, "-root") : "".concat(props.prefixCls, "-root");

    var subPopupMenuProps = _extends(_extends({}, props), {
      itemIcon: (0, _propsUtil.getComponent)(this, 'itemIcon', props),
      expandIcon: (0, _propsUtil.getComponent)(this, 'expandIcon', props),
      overflowedIndicator: (0, _propsUtil.getComponent)(this, 'overflowedIndicator', props) || (0, _vue.createVNode)("span", null, [(0, _vue.createTextVNode)("\xB7\xB7\xB7")]),
      openTransitionName: this.getOpenTransitionName(),
      onClick: this.handleClick,
      onOpenChange: this.onOpenChange,
      onDeselect: this.handleDeselect,
      onSelect: this.handleSelect,
      ref: this.saveInnerMenu,
      store: this.store
    });

    return (0, _vue.createVNode)(_SubPopupMenu.default, subPopupMenuProps, this.$slots);
  }
};

var _default = (0, _vue.defineComponent)(Menu);

exports.default = _default;