"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "buttonProps", {
  enumerable: true,
  get: function get() {
    return _buttonTypes.default;
  }
});
exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _wave = _interopRequireDefault(require("../_util/wave"));
var _buttonTypes = _interopRequireDefault(require("./buttonTypes"));
var _propsUtil = require("../_util/props-util");
var _useConfigInject2 = _interopRequireDefault(require("../_util/hooks/useConfigInject"));
var _devWarning = _interopRequireDefault(require("../vc-util/devWarning"));
var _LoadingIcon = _interopRequireDefault(require("./LoadingIcon"));
var rxTwoCNChar = /^[\u4e00-\u9fa5]{2}$/;
var isTwoCNChar = rxTwoCNChar.test.bind(rxTwoCNChar);
function isUnborderedButtonType(type) {
  return type === 'text' || type === 'link';
}
var _default2 = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'AButton',
  inheritAttrs: false,
  __ANT_BUTTON: true,
  props: (0, _propsUtil.initDefaultProps)((0, _buttonTypes.default)(), {
    type: 'default'
  }),
  slots: ['icon'],
  // emits: ['click', 'mousedown'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs,
      emit = _ref.emit,
      expose = _ref.expose;
    var _useConfigInject = (0, _useConfigInject2.default)('btn', props),
      prefixCls = _useConfigInject.prefixCls,
      autoInsertSpaceInButton = _useConfigInject.autoInsertSpaceInButton,
      direction = _useConfigInject.direction,
      size = _useConfigInject.size;
    var buttonNodeRef = (0, _vue.ref)(null);
    var delayTimeoutRef = (0, _vue.ref)(undefined);
    var isNeedInserted = false;
    var innerLoading = (0, _vue.ref)(false);
    var hasTwoCNChar = (0, _vue.ref)(false);
    var autoInsertSpace = (0, _vue.computed)(function () {
      return autoInsertSpaceInButton.value !== false;
    });
    // =============== Update Loading ===============
    var loadingOrDelay = (0, _vue.computed)(function () {
      return (0, _typeof2.default)(props.loading) === 'object' && props.loading.delay ? props.loading.delay || true : !!props.loading;
    });
    (0, _vue.watch)(loadingOrDelay, function (val) {
      clearTimeout(delayTimeoutRef.value);
      if (typeof loadingOrDelay.value === 'number') {
        delayTimeoutRef.value = setTimeout(function () {
          innerLoading.value = val;
        }, loadingOrDelay.value);
      } else {
        innerLoading.value = val;
      }
    }, {
      immediate: true
    });
    var classes = (0, _vue.computed)(function () {
      var _ref2;
      var type = props.type,
        _props$shape = props.shape,
        shape = _props$shape === void 0 ? 'default' : _props$shape,
        ghost = props.ghost,
        block = props.block,
        danger = props.danger;
      var pre = prefixCls.value;
      var sizeClassNameMap = {
        large: 'lg',
        small: 'sm',
        middle: undefined
      };
      var sizeFullname = size.value;
      var sizeCls = sizeFullname ? sizeClassNameMap[sizeFullname] || '' : '';
      return _ref2 = {}, (0, _defineProperty2.default)(_ref2, "".concat(pre), true), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-").concat(type), type), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-").concat(shape), shape !== 'default' && shape), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-").concat(sizeCls), sizeCls), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-loading"), innerLoading.value), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-background-ghost"), ghost && !isUnborderedButtonType(type)), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-two-chinese-chars"), hasTwoCNChar.value && autoInsertSpace.value), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-block"), block), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-dangerous"), !!danger), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-rtl"), direction.value === 'rtl'), _ref2;
    });
    var fixTwoCNChar = function fixTwoCNChar() {
      // Fix for HOC usage like <FormatMessage />
      var node = buttonNodeRef.value;
      if (!node || autoInsertSpaceInButton.value === false) {
        return;
      }
      var buttonText = node.textContent;
      if (isNeedInserted && isTwoCNChar(buttonText)) {
        if (!hasTwoCNChar.value) {
          hasTwoCNChar.value = true;
        }
      } else if (hasTwoCNChar.value) {
        hasTwoCNChar.value = false;
      }
    };
    var handleClick = function handleClick(event) {
      // https://github.com/ant-design/ant-design/issues/30207
      if (innerLoading.value || props.disabled) {
        event.preventDefault();
        return;
      }
      emit('click', event);
    };
    var insertSpace = function insertSpace(child, needInserted) {
      var SPACE = needInserted ? ' ' : '';
      if (child.type === _vue.Text) {
        var text = child.children.trim();
        if (isTwoCNChar(text)) {
          text = text.split('').join(SPACE);
        }
        return (0, _vue.createVNode)("span", null, [text]);
      }
      return child;
    };
    (0, _vue.watchEffect)(function () {
      (0, _devWarning.default)(!(props.ghost && isUnborderedButtonType(props.type)), 'Button', "`link` or `text` button can't be a `ghost` button.");
    });
    (0, _vue.onMounted)(fixTwoCNChar);
    (0, _vue.onUpdated)(fixTwoCNChar);
    (0, _vue.onBeforeUnmount)(function () {
      delayTimeoutRef.value && clearTimeout(delayTimeoutRef.value);
    });
    var focus = function focus() {
      var _buttonNodeRef$value;
      (_buttonNodeRef$value = buttonNodeRef.value) === null || _buttonNodeRef$value === void 0 ? void 0 : _buttonNodeRef$value.focus();
    };
    var blur = function blur() {
      var _buttonNodeRef$value2;
      (_buttonNodeRef$value2 = buttonNodeRef.value) === null || _buttonNodeRef$value2 === void 0 ? void 0 : _buttonNodeRef$value2.blur();
    };
    expose({
      focus: focus,
      blur: blur
    });
    return function () {
      var _slots$icon, _slots$default;
      var _props$icon = props.icon,
        icon = _props$icon === void 0 ? (_slots$icon = slots.icon) === null || _slots$icon === void 0 ? void 0 : _slots$icon.call(slots) : _props$icon;
      var children = (0, _propsUtil.flattenChildren)((_slots$default = slots.default) === null || _slots$default === void 0 ? void 0 : _slots$default.call(slots));
      isNeedInserted = children.length === 1 && !icon && !isUnborderedButtonType(props.type);
      var type = props.type,
        htmlType = props.htmlType,
        disabled = props.disabled,
        href = props.href,
        title = props.title,
        target = props.target,
        onMousedown = props.onMousedown;
      var iconType = innerLoading.value ? 'loading' : icon;
      var buttonProps = (0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), {}, {
        title: title,
        disabled: disabled,
        class: [classes.value, attrs.class, (0, _defineProperty2.default)({}, "".concat(prefixCls.value, "-icon-only"), children.length === 0 && !!iconType)],
        onClick: handleClick,
        onMousedown: onMousedown
      });
      // https://github.com/vueComponent/ant-design-vue/issues/4930
      if (!disabled) {
        delete buttonProps.disabled;
      }
      var iconNode = icon && !innerLoading.value ? icon : (0, _vue.createVNode)(_LoadingIcon.default, {
        "existIcon": !!icon,
        "prefixCls": prefixCls.value,
        "loading": !!innerLoading.value
      }, null);
      var kids = children.map(function (child) {
        return insertSpace(child, isNeedInserted && autoInsertSpace.value);
      });
      if (href !== undefined) {
        return (0, _vue.createVNode)("a", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, buttonProps), {}, {
          "href": href,
          "target": target,
          "ref": buttonNodeRef
        }), [iconNode, kids]);
      }
      var buttonNode = (0, _vue.createVNode)("button", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, buttonProps), {}, {
        "ref": buttonNodeRef,
        "type": htmlType
      }), [iconNode, kids]);
      if (isUnborderedButtonType(type)) {
        return buttonNode;
      }
      return (0, _vue.createVNode)(_wave.default, {
        "ref": "wave",
        "disabled": !!innerLoading.value
      }, {
        default: function _default() {
          return [buttonNode];
        }
      });
    };
  }
});
exports.default = _default2;