"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ListItem", {
  enumerable: true,
  get: function get() {
    return _Item.default;
  }
});
Object.defineProperty(exports, "ListItemMeta", {
  enumerable: true,
  get: function get() {
    return _ItemMeta.default;
  }
});
exports.listProps = exports.default = void 0;
var _vue = require("vue");
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _objectSpread3 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _spin = _interopRequireDefault(require("../spin"));
var _pagination = _interopRequireDefault(require("../pagination"));
var _grid = require("../grid");
var _Item = _interopRequireDefault(require("./Item"));
var _propsUtil = require("../_util/props-util");
var _initDefaultProps = _interopRequireDefault(require("../_util/props-util/initDefaultProps"));
var _ItemMeta = _interopRequireDefault(require("./ItemMeta"));
var _useConfigInject2 = _interopRequireDefault(require("../_util/hooks/useConfigInject"));
var _useBreakpoint = _interopRequireDefault(require("../_util/hooks/useBreakpoint"));
var _responsiveObserve = require("../_util/responsiveObserve");
var _eagerComputed = _interopRequireDefault(require("../_util/eagerComputed"));
var _contextKey = require("./contextKey");
var listProps = function listProps() {
  return {
    bordered: {
      type: Boolean,
      default: undefined
    },
    dataSource: _vueTypes.default.array,
    extra: _vueTypes.default.any,
    grid: {
      type: Object,
      default: undefined
    },
    itemLayout: String,
    loading: {
      type: [Boolean, Object],
      default: undefined
    },
    loadMore: _vueTypes.default.any,
    pagination: {
      type: [Boolean, Object],
      default: undefined
    },
    prefixCls: String,
    rowKey: [String, Number, Function],
    renderItem: Function,
    size: String,
    split: {
      type: Boolean,
      default: undefined
    },
    header: _vueTypes.default.any,
    footer: _vueTypes.default.any,
    locale: {
      type: Object
    }
  };
};
exports.listProps = listProps;
var List = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'AList',
  Item: _Item.default,
  props: (0, _initDefaultProps.default)(listProps(), {
    dataSource: [],
    bordered: false,
    split: true,
    loading: false,
    pagination: false
  }),
  slots: ['extra', 'loadMore', 'renderItem', 'header', 'footer'],
  setup: function setup(props, _ref) {
    var _paginationObj$value$, _paginationObj$value$2;
    var slots = _ref.slots;
    (0, _vue.provide)(_contextKey.ListContextKey, {
      grid: (0, _vue.toRef)(props, 'grid'),
      itemLayout: (0, _vue.toRef)(props, 'itemLayout')
    });
    var defaultPaginationProps = {
      current: 1,
      total: 0
    };
    var _useConfigInject = (0, _useConfigInject2.default)('list', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction,
      renderEmpty = _useConfigInject.renderEmpty;
    var paginationObj = (0, _vue.computed)(function () {
      return props.pagination && (0, _typeof2.default)(props.pagination) === 'object' ? props.pagination : {};
    });
    var paginationCurrent = (0, _vue.ref)((_paginationObj$value$ = paginationObj.value.defaultCurrent) !== null && _paginationObj$value$ !== void 0 ? _paginationObj$value$ : 1);
    var paginationSize = (0, _vue.ref)((_paginationObj$value$2 = paginationObj.value.defaultPageSize) !== null && _paginationObj$value$2 !== void 0 ? _paginationObj$value$2 : 10);
    (0, _vue.watch)(paginationObj, function () {
      if ('current' in paginationObj.value) {
        paginationCurrent.value = paginationObj.value.current;
      }
      if ('pageSize' in paginationObj.value) {
        paginationSize.value = paginationObj.value.pageSize;
      }
    });
    var listItemsKeys = [];
    var triggerPaginationEvent = function triggerPaginationEvent(eventName) {
      return function (page, pageSize) {
        paginationCurrent.value = page;
        paginationSize.value = pageSize;
        if (paginationObj.value[eventName]) {
          paginationObj.value[eventName](page, pageSize);
        }
      };
    };
    var onPaginationChange = triggerPaginationEvent('onChange');
    var onPaginationShowSizeChange = triggerPaginationEvent('onShowSizeChange');
    var renderEmptyFunc = function renderEmptyFunc(renderEmptyHandler) {
      var _props$locale;
      return (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls.value, "-empty-text")
      }, [((_props$locale = props.locale) === null || _props$locale === void 0 ? void 0 : _props$locale.emptyText) || renderEmptyHandler('List')]);
    };
    var loadingProp = (0, _vue.computed)(function () {
      if (typeof props.loading === 'boolean') {
        return {
          spinning: props.loading
        };
      } else {
        return props.loading;
      }
    });
    var isLoading = (0, _vue.computed)(function () {
      return loadingProp.value && loadingProp.value.spinning;
    });
    var sizeCls = (0, _vue.computed)(function () {
      var size = '';
      switch (props.size) {
        case 'large':
          size = 'lg';
          break;
        case 'small':
          size = 'sm';
          break;
        default:
          break;
      }
      return size;
    });
    var classObj = (0, _vue.computed)(function () {
      var _ref2;
      return _ref2 = {}, (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value), true), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value, "-vertical"), props.itemLayout === 'vertical'), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value, "-").concat(sizeCls.value), sizeCls.value), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value, "-split"), props.split), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value, "-bordered"), props.bordered), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value, "-loading"), isLoading.value), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value, "-grid"), !!props.grid), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), _ref2;
    });
    var paginationProps = (0, _vue.computed)(function () {
      var pp = (0, _objectSpread3.default)((0, _objectSpread3.default)({}, defaultPaginationProps), {}, {
        total: props.dataSource.length,
        current: paginationCurrent.value,
        pageSize: paginationSize.value
      }, props.pagination || {});
      var largestPage = Math.ceil(pp.total / pp.pageSize);
      if (pp.current > largestPage) {
        pp.current = largestPage;
      }
      return pp;
    });
    var splitDataSource = (0, _vue.computed)(function () {
      var dd = (0, _toConsumableArray2.default)(props.dataSource);
      if (props.pagination) {
        if (props.dataSource.length > (paginationProps.value.current - 1) * paginationProps.value.pageSize) {
          dd = (0, _toConsumableArray2.default)(props.dataSource).splice((paginationProps.value.current - 1) * paginationProps.value.pageSize, paginationProps.value.pageSize);
        }
      }
      return dd;
    });
    var screens = (0, _useBreakpoint.default)();
    var currentBreakpoint = (0, _eagerComputed.default)(function () {
      for (var i = 0; i < _responsiveObserve.responsiveArray.length; i += 1) {
        var breakpoint = _responsiveObserve.responsiveArray[i];
        if (screens.value[breakpoint]) {
          return breakpoint;
        }
      }
      return undefined;
    });
    var colStyle = (0, _vue.computed)(function () {
      if (!props.grid) {
        return undefined;
      }
      var columnCount = currentBreakpoint.value && props.grid[currentBreakpoint.value] ? props.grid[currentBreakpoint.value] : props.grid.column;
      if (columnCount) {
        return {
          width: "".concat(100 / columnCount, "%"),
          maxWidth: "".concat(100 / columnCount, "%")
        };
      }
      return undefined;
    });
    var renderInnerItem = function renderInnerItem(item, index) {
      var _props$renderItem;
      var renderItem = (_props$renderItem = props.renderItem) !== null && _props$renderItem !== void 0 ? _props$renderItem : slots.renderItem;
      if (!renderItem) return null;
      var key;
      var rowKeyType = (0, _typeof2.default)(props.rowKey);
      if (rowKeyType === 'function') {
        key = props.rowKey(item);
      } else if (rowKeyType === 'string' || rowKeyType === 'number') {
        key = item[props.rowKey];
      } else {
        key = item.key;
      }
      if (!key) {
        key = "list-item-".concat(index);
      }
      listItemsKeys[index] = key;
      return renderItem({
        item: item,
        index: index
      });
    };
    return function () {
      var _props$loadMore, _slots$loadMore, _props$footer, _slots$footer, _props$header, _slots$header, _slots$default;
      var loadMore = (_props$loadMore = props.loadMore) !== null && _props$loadMore !== void 0 ? _props$loadMore : (_slots$loadMore = slots.loadMore) === null || _slots$loadMore === void 0 ? void 0 : _slots$loadMore.call(slots);
      var footer = (_props$footer = props.footer) !== null && _props$footer !== void 0 ? _props$footer : (_slots$footer = slots.footer) === null || _slots$footer === void 0 ? void 0 : _slots$footer.call(slots);
      var header = (_props$header = props.header) !== null && _props$header !== void 0 ? _props$header : (_slots$header = slots.header) === null || _slots$header === void 0 ? void 0 : _slots$header.call(slots);
      var children = (0, _propsUtil.flattenChildren)((_slots$default = slots.default) === null || _slots$default === void 0 ? void 0 : _slots$default.call(slots));
      var isSomethingAfterLastItem = !!(loadMore || props.pagination || footer);
      var classString = (0, _objectSpread3.default)((0, _objectSpread3.default)({}, classObj.value), {}, (0, _defineProperty2.default)({}, "".concat(prefixCls.value, "-something-after-last-item"), isSomethingAfterLastItem));
      var paginationContent = props.pagination ? (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls.value, "-pagination")
      }, [(0, _vue.createVNode)(_pagination.default, (0, _objectSpread3.default)((0, _objectSpread3.default)({}, paginationProps.value), {}, {
        "onChange": onPaginationChange,
        "onShowSizeChange": onPaginationShowSizeChange
      }), null)]) : null;
      var childrenContent = isLoading.value && (0, _vue.createVNode)("div", {
        "style": {
          minHeight: '53px'
        }
      }, null);
      if (splitDataSource.value.length > 0) {
        listItemsKeys.length = 0;
        var items = splitDataSource.value.map(function (item, index) {
          return renderInnerItem(item, index);
        });
        var childrenList = items.map(function (child, index) {
          return (0, _vue.createVNode)("div", {
            "key": listItemsKeys[index],
            "style": colStyle.value
          }, [child]);
        });
        childrenContent = props.grid ? (0, _vue.createVNode)(_grid.Row, {
          "gutter": props.grid.gutter
        }, {
          default: function _default() {
            return [childrenList];
          }
        }) : (0, _vue.createVNode)("ul", {
          "class": "".concat(prefixCls.value, "-items")
        }, [items]);
      } else if (!children.length && !isLoading.value) {
        childrenContent = renderEmptyFunc(renderEmpty.value);
      }
      var paginationPosition = paginationProps.value.position || 'bottom';
      return (0, _vue.createVNode)("div", {
        "class": classString
      }, [(paginationPosition === 'top' || paginationPosition === 'both') && paginationContent, header && (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls.value, "-header")
      }, [header]), (0, _vue.createVNode)(_spin.default, loadingProp.value, {
        default: function _default() {
          return [childrenContent, children];
        }
      }), footer && (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls.value, "-footer")
      }, [footer]), loadMore || (paginationPosition === 'bottom' || paginationPosition === 'both') && paginationContent]);
    };
  }
});
/* istanbul ignore next */
List.install = function (app) {
  app.component(List.name, List);
  app.component(List.Item.name, List.Item);
  app.component(List.Item.Meta.name, List.Item.Meta);
  return app;
};
var _default2 = List;
exports.default = _default2;