import _extends from "@babel/runtime/helpers/esm/extends";
import { inject, provide, reactive, watchEffect } from 'vue';
function createContext(defaultValue) {
  var contextKey = Symbol('contextKey');
  var useProvide = function useProvide(props, newProps) {
    var mergedProps = reactive({});
    provide(contextKey, mergedProps);
    watchEffect(function () {
      _extends(mergedProps, props, newProps || {});
    });
    return mergedProps;
  };
  var useInject = function useInject() {
    return inject(contextKey, defaultValue) || {};
  };
  return {
    useProvide: useProvide,
    useInject: useInject
  };
}
export default createContext;