import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
var Entity = /*#__PURE__*/function () {
  function Entity() {
    _classCallCheck(this, Entity);
    /** @private Internal cache map. Do not access this directly */
    this.cache = new Map();
  }
  _createClass(Entity, [{
    key: "get",
    value: function get(keys) {
      return this.cache.get(Array.isArray(keys) ? keys.join('%') : keys) || null;
    }
  }, {
    key: "update",
    value: function update(keys, valueFn) {
      var path = Array.isArray(keys) ? keys.join('%') : keys;
      var prevValue = this.cache.get(path);
      var nextValue = valueFn(prevValue);
      if (nextValue === null) {
        this.cache.delete(path);
      } else {
        this.cache.set(path, nextValue);
      }
    }
  }]);
  return Entity;
}();
export default Entity;