import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";
import _extends from "@babel/runtime/helpers/esm/extends";
import hash from '@emotion/hash';
import { ATTR_TOKEN, CSS_IN_JS_INSTANCE, CSS_IN_JS_INSTANCE_ID } from '../StyleContext';
import useGlobalCache from './useGlobalCache';
import { flattenToken, token2key } from '../util';
import { ref, computed } from 'vue';
var EMPTY_OVERRIDE = {};
// Generate different prefix to make user selector break in production env.
// This helps developer not to do style override directly on the hash id.
var hashPrefix = process.env.NODE_ENV !== 'production' ? 'css-dev-only-do-not-override' : 'css';
var tokenKeys = new Map();
function recordCleanToken(tokenKey) {
  tokenKeys.set(tokenKey, (tokenKeys.get(tokenKey) || 0) + 1);
}
function removeStyleTags(key) {
  if (typeof document !== 'undefined') {
    var styles = document.querySelectorAll("style[".concat(ATTR_TOKEN, "=\"").concat(key, "\"]"));
    styles.forEach(function (style) {
      var _a;
      if (style[CSS_IN_JS_INSTANCE] === CSS_IN_JS_INSTANCE_ID) {
        (_a = style.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(style);
      }
    });
  }
}
// Remove will check current keys first
function cleanTokenStyle(tokenKey) {
  tokenKeys.set(tokenKey, (tokenKeys.get(tokenKey) || 0) - 1);
  var tokenKeyList = Array.from(tokenKeys.keys());
  var cleanableKeyList = tokenKeyList.filter(function (key) {
    var count = tokenKeys.get(key) || 0;
    return count <= 0;
  });
  if (cleanableKeyList.length < tokenKeyList.length) {
    cleanableKeyList.forEach(function (key) {
      removeStyleTags(key);
      tokenKeys.delete(key);
    });
  }
}
/**
 * Cache theme derivative token as global shared one
 * @param theme Theme entity
 * @param tokens List of tokens, used for cache. Please do not dynamic generate object directly
 * @param option Additional config
 * @returns Call Theme.getDerivativeToken(tokenObject) to get token
 */
export default function useCacheToken(theme, tokens) {
  var option = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : ref({});
  // Basic - We do basic cache here
  var mergedToken = computed(function () {
    return _extends.apply(void 0, [{}].concat(_toConsumableArray(tokens.value)));
  });
  var tokenStr = computed(function () {
    return flattenToken(mergedToken.value);
  });
  var overrideTokenStr = computed(function () {
    return flattenToken(option.value.override || EMPTY_OVERRIDE);
  });
  var cachedToken = useGlobalCache('token', computed(function () {
    return [option.value.salt || '', theme.value.id, tokenStr.value, overrideTokenStr.value];
  }), function () {
    var _option$value = option.value,
      _option$value$salt = _option$value.salt,
      salt = _option$value$salt === void 0 ? '' : _option$value$salt,
      _option$value$overrid = _option$value.override,
      override = _option$value$overrid === void 0 ? EMPTY_OVERRIDE : _option$value$overrid,
      formatToken = _option$value.formatToken;
    var derivativeToken = theme.value.getDerivativeToken(mergedToken.value);
    // Merge with override
    var mergedDerivativeToken = _extends(_extends({}, derivativeToken), override);
    // Format if needed
    if (formatToken) {
      mergedDerivativeToken = formatToken(mergedDerivativeToken);
    }
    // Optimize for `useStyleRegister` performance
    var tokenKey = token2key(mergedDerivativeToken, salt);
    mergedDerivativeToken._tokenKey = tokenKey;
    recordCleanToken(tokenKey);
    var hashId = "".concat(hashPrefix, "-").concat(hash(tokenKey));
    mergedDerivativeToken._hashId = hashId; // Not used
    return [mergedDerivativeToken, hashId];
  }, function (cache) {
    // Remove token will remove all related style
    cleanTokenStyle(cache[0]._tokenKey);
  });
  return cachedToken;
}