import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";
import { useStyleInject } from '../StyleContext';
import useHMR from './useHMR';
import { onBeforeUnmount, watch, watchEffect, shallowRef } from 'vue';
export default function useClientCache(prefix, keyPath, cacheFn, onCacheRemove) {
  var styleContext = useStyleInject();
  var fullPathStr = shallowRef('');
  var res = shallowRef();
  watchEffect(function () {
    fullPathStr.value = [prefix].concat(_toConsumableArray(keyPath.value)).join('%');
  });
  var HMRUpdate = useHMR();
  var clearCache = function clearCache(pathStr) {
    styleContext.value.cache.update(pathStr, function (prevCache) {
      var _ref = prevCache || [],
        _ref2 = _slicedToArray(_ref, 2),
        _ref2$ = _ref2[0],
        times = _ref2$ === void 0 ? 0 : _ref2$,
        cache = _ref2[1];
      var nextCount = times - 1;
      if (nextCount === 0) {
        onCacheRemove === null || onCacheRemove === void 0 ? void 0 : onCacheRemove(cache, false);
        return null;
      }
      return [times - 1, cache];
    });
  };
  watch(fullPathStr, function (newStr, oldStr) {
    if (oldStr) clearCache(oldStr);
    // Create cache
    styleContext.value.cache.update(newStr, function (prevCache) {
      var _ref3 = prevCache || [],
        _ref4 = _slicedToArray(_ref3, 2),
        _ref4$ = _ref4[0],
        times = _ref4$ === void 0 ? 0 : _ref4$,
        cache = _ref4[1];
      // HMR should always ignore cache since developer may change it
      var tmpCache = cache;
      if (process.env.NODE_ENV !== 'production' && cache && HMRUpdate) {
        onCacheRemove === null || onCacheRemove === void 0 ? void 0 : onCacheRemove(tmpCache, HMRUpdate);
        tmpCache = null;
      }
      var mergedCache = tmpCache || cacheFn();
      return [times + 1, mergedCache];
    });
    res.value = styleContext.value.cache.get(fullPathStr.value)[1];
  }, {
    immediate: true
  });
  onBeforeUnmount(function () {
    clearCache(fullPathStr.value);
  });
  return res;
}