import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { computed } from 'vue';
import { useToken } from '../theme/internal';
export var responsiveArray = ['xxxl', 'xxl', 'xl', 'lg', 'md', 'sm', 'xs'];
var getResponsiveMap = function getResponsiveMap(token) {
  return {
    xs: "(max-width: ".concat(token.screenXSMax, "px)"),
    sm: "(min-width: ".concat(token.screenSM, "px)"),
    md: "(min-width: ".concat(token.screenMD, "px)"),
    lg: "(min-width: ".concat(token.screenLG, "px)"),
    xl: "(min-width: ".concat(token.screenXL, "px)"),
    xxl: "(min-width: ".concat(token.screenXXL, "px)"),
    xxxl: "{min-width: ".concat(token.screenXXXL, "px}")
  };
};
export default function useResponsiveObserver() {
  var _useToken = useToken(),
    _useToken2 = _slicedToArray(_useToken, 2),
    token = _useToken2[1];
  return computed(function () {
    var responsiveMap = getResponsiveMap(token.value);
    var subscribers = new Map();
    var subUid = -1;
    var screens = {};
    return {
      matchHandlers: {},
      dispatch: function dispatch(pointMap) {
        screens = pointMap;
        subscribers.forEach(function (func) {
          return func(screens);
        });
        return subscribers.size >= 1;
      },
      subscribe: function subscribe(func) {
        if (!subscribers.size) this.register();
        subUid += 1;
        subscribers.set(subUid, func);
        func(screens);
        return subUid;
      },
      unsubscribe: function unsubscribe(paramToken) {
        subscribers.delete(paramToken);
        if (!subscribers.size) this.unregister();
      },
      unregister: function unregister() {
        var _this = this;
        Object.keys(responsiveMap).forEach(function (screen) {
          var matchMediaQuery = responsiveMap[screen];
          var handler = _this.matchHandlers[matchMediaQuery];
          handler === null || handler === void 0 ? void 0 : handler.mql.removeListener(handler === null || handler === void 0 ? void 0 : handler.listener);
        });
        subscribers.clear();
      },
      register: function register() {
        var _this2 = this;
        Object.keys(responsiveMap).forEach(function (screen) {
          var matchMediaQuery = responsiveMap[screen];
          var listener = function listener(_ref) {
            var matches = _ref.matches;
            _this2.dispatch(_extends(_extends({}, screens), _defineProperty({}, screen, matches)));
          };
          var mql = window.matchMedia(matchMediaQuery);
          mql.addListener(listener);
          _this2.matchHandlers[matchMediaQuery] = {
            mql: mql,
            listener: listener
          };
          listener(mql);
        });
      },
      responsiveMap: responsiveMap
    };
  });
}