import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
import { onBeforeUnmount, onMounted, Transition, render, defineComponent, shallowRef } from 'vue';
import useState from '../hooks/useState';
import { objectType } from '../type';
import { getTargetWaveColor } from './util';
import wrapperRaf from '../raf';
function validateNum(value) {
  return Number.isNaN(value) ? 0 : value;
}
var WaveEffect = defineComponent({
  props: {
    target: objectType(),
    className: String
  },
  setup: function setup(props) {
    var divRef = shallowRef(null);
    var _useState = useState(null),
      _useState2 = _slicedToArray(_useState, 2),
      color = _useState2[0],
      setWaveColor = _useState2[1];
    var _useState3 = useState([]),
      _useState4 = _slicedToArray(_useState3, 2),
      borderRadius = _useState4[0],
      setBorderRadius = _useState4[1];
    var _useState5 = useState(0),
      _useState6 = _slicedToArray(_useState5, 2),
      left = _useState6[0],
      setLeft = _useState6[1];
    var _useState7 = useState(0),
      _useState8 = _slicedToArray(_useState7, 2),
      top = _useState8[0],
      setTop = _useState8[1];
    var _useState9 = useState(0),
      _useState10 = _slicedToArray(_useState9, 2),
      width = _useState10[0],
      setWidth = _useState10[1];
    var _useState11 = useState(0),
      _useState12 = _slicedToArray(_useState11, 2),
      height = _useState12[0],
      setHeight = _useState12[1];
    var _useState13 = useState(false),
      _useState14 = _slicedToArray(_useState13, 2),
      enabled = _useState14[0],
      setEnabled = _useState14[1];
    function syncPos() {
      var target = props.target;
      var nodeStyle = getComputedStyle(target);
      // Get wave color from target
      setWaveColor(getTargetWaveColor(target));
      var isStatic = nodeStyle.position === 'static';
      // Rect
      var borderLeftWidth = nodeStyle.borderLeftWidth,
        borderTopWidth = nodeStyle.borderTopWidth;
      setLeft(isStatic ? target.offsetLeft : validateNum(-parseFloat(borderLeftWidth)));
      setTop(isStatic ? target.offsetTop : validateNum(-parseFloat(borderTopWidth)));
      setWidth(target.offsetWidth);
      setHeight(target.offsetHeight);
      // Get border radius
      var borderTopLeftRadius = nodeStyle.borderTopLeftRadius,
        borderTopRightRadius = nodeStyle.borderTopRightRadius,
        borderBottomLeftRadius = nodeStyle.borderBottomLeftRadius,
        borderBottomRightRadius = nodeStyle.borderBottomRightRadius;
      setBorderRadius([borderTopLeftRadius, borderTopRightRadius, borderBottomRightRadius, borderBottomLeftRadius].map(function (radius) {
        return validateNum(parseFloat(radius));
      }));
    }
    // Add resize observer to follow size
    var resizeObserver;
    var rafId;
    var timeoutId;
    var clear = function clear() {
      clearTimeout(timeoutId);
      wrapperRaf.cancel(rafId);
      resizeObserver === null || resizeObserver === void 0 ? void 0 : resizeObserver.disconnect();
    };
    var removeDom = function removeDom() {
      var _a;
      var holder = (_a = divRef.value) === null || _a === void 0 ? void 0 : _a.parentElement;
      if (holder) {
        render(null, holder);
        if (holder.parentElement) {
          holder.parentElement.removeChild(holder);
        }
      }
    };
    onMounted(function () {
      clear();
      timeoutId = setTimeout(function () {
        removeDom();
      }, 5000);
      var target = props.target;
      if (target) {
        // We need delay to check position here
        // since UI may change after click
        rafId = wrapperRaf(function () {
          syncPos();
          setEnabled(true);
        });
        if (typeof ResizeObserver !== 'undefined') {
          resizeObserver = new ResizeObserver(syncPos);
          resizeObserver.observe(target);
        }
      }
    });
    onBeforeUnmount(function () {
      clear();
    });
    var onTransitionend = function onTransitionend(e) {
      if (e.propertyName === 'opacity') {
        removeDom();
      }
    };
    return function () {
      if (!enabled.value) {
        return null;
      }
      var waveStyle = {
        left: "".concat(left.value, "px"),
        top: "".concat(top.value, "px"),
        width: "".concat(width.value, "px"),
        height: "".concat(height.value, "px"),
        borderRadius: borderRadius.value.map(function (radius) {
          return "".concat(radius, "px");
        }).join(' ')
      };
      if (color) {
        waveStyle['--wave-color'] = color.value;
      }
      return _createVNode(Transition, {
        "appear": true,
        "name": "wave-motion",
        "appearFromClass": "wave-motion-appear",
        "appearActiveClass": "wave-motion-appear",
        "appearToClass": "wave-motion-appear wave-motion-appear-active"
      }, {
        default: function _default() {
          return [_createVNode("div", {
            "ref": divRef,
            "class": props.className,
            "style": waveStyle,
            "onTransitionend": onTransitionend
          }, null)];
        }
      });
    };
  }
});
function showWaveEffect(node, className) {
  // Create holder
  var holder = document.createElement('div');
  holder.style.position = 'absolute';
  holder.style.left = "0px";
  holder.style.top = "0px";
  node === null || node === void 0 ? void 0 : node.insertBefore(holder, node === null || node === void 0 ? void 0 : node.firstChild);
  render(_createVNode(WaveEffect, {
    "target": node,
    "className": className
  }, null), holder);
}
export default showWaveEffect;