import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { computed, defineComponent, getCurrentInstance, nextTick, onBeforeUnmount, onMounted, watch } from 'vue';
import useConfigInject from '../../config-provider/hooks/useConfigInject';
import isVisible from '../../vc-util/Dom/isVisible';
import classNames from '../classNames';
import { findDOMNode } from '../props-util';
import useStyle from './style';
import useWave from './useWave';
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'Wave',
  props: {
    disabled: Boolean
  },
  setup: function setup(props, _ref) {
    var slots = _ref.slots;
    var instance = getCurrentInstance();
    var _useConfigInject = useConfigInject('wave', props),
      prefixCls = _useConfigInject.prefixCls;
    // ============================== Style ===============================
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      hashId = _useStyle2[1];
    // =============================== Wave ===============================
    var showWave = useWave(instance, computed(function () {
      return classNames(prefixCls.value, hashId.value);
    }));
    var onClick;
    var clear = function clear() {
      var node = findDOMNode(instance);
      node.removeEventListener('click', onClick, true);
    };
    onMounted(function () {
      watch(function () {
        return props.disabled;
      }, function () {
        clear();
        nextTick(function () {
          var node = findDOMNode(instance);
          if (!node || node.nodeType !== 1 || props.disabled) {
            return;
          }
          // Click handler
          var onClick = function onClick(e) {
            // Fix radio button click twice
            if (e.target.tagName === 'INPUT' || !isVisible(e.target) ||
            // No need wave
            !node.getAttribute || node.getAttribute('disabled') || node.disabled || node.className.includes('disabled') || node.className.includes('-leave')) {
              return;
            }
            showWave();
          };
          // Bind events
          node.addEventListener('click', onClick, true);
        });
      }, {
        immediate: true,
        flush: 'post'
      });
    });
    onBeforeUnmount(function () {
      clear();
    });
    return function () {
      var _a;
      // ============================== Render ==============================
      var children = (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)[0];
      return children;
    };
  }
});