import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { withDirectives as _withDirectives, vShow as _vShow, createVNode as _createVNode } from "vue";
import { computed, defineComponent, shallowRef } from 'vue';
import CloseOutlined from "@ant-design/icons-vue/es/icons/CloseOutlined";
import CheckCircleOutlined from "@ant-design/icons-vue/es/icons/CheckCircleOutlined";
import ExclamationCircleOutlined from "@ant-design/icons-vue/es/icons/ExclamationCircleOutlined";
import InfoCircleOutlined from "@ant-design/icons-vue/es/icons/InfoCircleOutlined";
import CloseCircleOutlined from "@ant-design/icons-vue/es/icons/CloseCircleOutlined";
import CheckCircleFilled from "@ant-design/icons-vue/es/icons/CheckCircleFilled";
import ExclamationCircleFilled from "@ant-design/icons-vue/es/icons/ExclamationCircleFilled";
import InfoCircleFilled from "@ant-design/icons-vue/es/icons/InfoCircleFilled";
import CloseCircleFilled from "@ant-design/icons-vue/es/icons/CloseCircleFilled";
import classNames from '../_util/classNames';
import PropTypes from '../_util/vue-types';
import { getTransitionProps, Transition } from '../_util/transition';
import { isValidElement } from '../_util/props-util';
import { tuple, withInstall } from '../_util/type';
import { cloneElement } from '../_util/vnode';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import useStyle from './style';
var iconMapFilled = {
  success: CheckCircleFilled,
  info: InfoCircleFilled,
  error: CloseCircleFilled,
  warning: ExclamationCircleFilled
};
var iconMapOutlined = {
  success: CheckCircleOutlined,
  info: InfoCircleOutlined,
  error: CloseCircleOutlined,
  warning: ExclamationCircleOutlined
};
var AlertTypes = tuple('success', 'info', 'warning', 'error');
export var alertProps = function alertProps() {
  return {
    /**
     * Type of Alert styles, options: `success`, `info`, `warning`, `error`
     */
    type: PropTypes.oneOf(AlertTypes),
    /** Whether Alert can be closed */
    closable: {
      type: Boolean,
      default: undefined
    },
    /** Close text to show */
    closeText: PropTypes.any,
    /** Content of Alert */
    message: PropTypes.any,
    /** Additional content of Alert */
    description: PropTypes.any,
    /** Trigger when animation ending of Alert */
    afterClose: Function,
    /** Whether to show icon */
    showIcon: {
      type: Boolean,
      default: undefined
    },
    prefixCls: String,
    banner: {
      type: Boolean,
      default: undefined
    },
    icon: PropTypes.any,
    closeIcon: PropTypes.any,
    onClose: Function
  };
};
var Alert = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'AAlert',
  inheritAttrs: false,
  props: alertProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit,
      attrs = _ref.attrs,
      expose = _ref.expose;
    var _useConfigInject = useConfigInject('alert', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var closing = shallowRef(false);
    var closed = shallowRef(false);
    var alertNode = shallowRef();
    var handleClose = function handleClose(e) {
      e.preventDefault();
      var dom = alertNode.value;
      dom.style.height = "".concat(dom.offsetHeight, "px");
      // Magic code
      // 重复一次后才能正确设置 height
      dom.style.height = "".concat(dom.offsetHeight, "px");
      closing.value = true;
      emit('close', e);
    };
    var animationEnd = function animationEnd() {
      var _a;
      closing.value = false;
      closed.value = true;
      (_a = props.afterClose) === null || _a === void 0 ? void 0 : _a.call(props);
    };
    var mergedType = computed(function () {
      var type = props.type;
      if (type !== undefined) {
        return type;
      }
      // banner 模式默认为警告
      return props.banner ? 'warning' : 'info';
    });
    expose({
      animationEnd: animationEnd
    });
    var motionStyle = shallowRef({});
    return function () {
      var _classNames;
      var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
      var banner = props.banner,
        _props$closeIcon = props.closeIcon,
        customCloseIcon = _props$closeIcon === void 0 ? (_a = slots.closeIcon) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$closeIcon;
      var closable = props.closable,
        showIcon = props.showIcon;
      var closeText = (_b = props.closeText) !== null && _b !== void 0 ? _b : (_c = slots.closeText) === null || _c === void 0 ? void 0 : _c.call(slots);
      var description = (_d = props.description) !== null && _d !== void 0 ? _d : (_e = slots.description) === null || _e === void 0 ? void 0 : _e.call(slots);
      var message = (_f = props.message) !== null && _f !== void 0 ? _f : (_g = slots.message) === null || _g === void 0 ? void 0 : _g.call(slots);
      var icon = (_h = props.icon) !== null && _h !== void 0 ? _h : (_j = slots.icon) === null || _j === void 0 ? void 0 : _j.call(slots);
      var action = (_k = slots.action) === null || _k === void 0 ? void 0 : _k.call(slots);
      // banner模式默认有 Icon
      showIcon = banner && showIcon === undefined ? true : showIcon;
      var IconType = (description ? iconMapOutlined : iconMapFilled)[mergedType.value] || null;
      // closeable when closeText is assigned
      if (closeText) {
        closable = true;
      }
      var prefixClsValue = prefixCls.value;
      var alertCls = classNames(prefixClsValue, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixClsValue, "-").concat(mergedType.value), true), _defineProperty(_classNames, "".concat(prefixClsValue, "-closing"), closing.value), _defineProperty(_classNames, "".concat(prefixClsValue, "-with-description"), !!description), _defineProperty(_classNames, "".concat(prefixClsValue, "-no-icon"), !showIcon), _defineProperty(_classNames, "".concat(prefixClsValue, "-banner"), !!banner), _defineProperty(_classNames, "".concat(prefixClsValue, "-closable"), closable), _defineProperty(_classNames, "".concat(prefixClsValue, "-rtl"), direction.value === 'rtl'), _defineProperty(_classNames, hashId.value, true), _classNames));
      var closeIcon = closable ? _createVNode("button", {
        "type": "button",
        "onClick": handleClose,
        "class": "".concat(prefixClsValue, "-close-icon"),
        "tabindex": 0
      }, [closeText ? _createVNode("span", {
        "class": "".concat(prefixClsValue, "-close-text")
      }, [closeText]) : customCloseIcon === undefined ? _createVNode(CloseOutlined, null, null) : customCloseIcon]) : null;
      var iconNode = icon && (isValidElement(icon) ? cloneElement(icon, {
        class: "".concat(prefixClsValue, "-icon")
      }) : _createVNode("span", {
        "class": "".concat(prefixClsValue, "-icon")
      }, [icon])) || _createVNode(IconType, {
        "class": "".concat(prefixClsValue, "-icon")
      }, null);
      var transitionProps = getTransitionProps("".concat(prefixClsValue, "-motion"), {
        appear: false,
        css: true,
        onAfterLeave: animationEnd,
        onBeforeLeave: function onBeforeLeave(node) {
          node.style.maxHeight = "".concat(node.offsetHeight, "px");
        },
        onLeave: function onLeave(node) {
          node.style.maxHeight = '0px';
        }
      });
      return wrapSSR(closed.value ? null : _createVNode(Transition, transitionProps, {
        default: function _default() {
          return [_withDirectives(_createVNode("div", _objectSpread(_objectSpread({
            "role": "alert"
          }, attrs), {}, {
            "style": [attrs.style, motionStyle.value],
            "class": [attrs.class, alertCls],
            "data-show": !closing.value,
            "ref": alertNode
          }), [showIcon ? iconNode : null, _createVNode("div", {
            "class": "".concat(prefixClsValue, "-content")
          }, [message ? _createVNode("div", {
            "class": "".concat(prefixClsValue, "-message")
          }, [message]) : null, description ? _createVNode("div", {
            "class": "".concat(prefixClsValue, "-description")
          }, [description]) : null]), action ? _createVNode("div", {
            "class": "".concat(prefixClsValue, "-action")
          }, [action]) : null, closeIcon]), [[_vShow, !closing.value]])];
        }
      }));
    };
  }
});
export default withInstall(Alert);