import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { createVNode as _createVNode } from "vue";
import { defineComponent, nextTick, onBeforeUnmount, onMounted, watch } from 'vue';
import { initDefaultProps } from '../_util/props-util';
import classNames from '../_util/classNames';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import { useInjectAnchor } from './context';
import { objectType, anyType } from '../_util/type';
export var anchorLinkProps = function anchorLinkProps() {
  return {
    prefixCls: String,
    href: String,
    title: anyType(),
    target: String,
    /* private use  */
    customTitleProps: objectType()
  };
};
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'AAnchorLink',
  inheritAttrs: false,
  props: initDefaultProps(anchorLinkProps(), {
    href: '#'
  }),
  slots: ['title', 'customTitle'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var mergedTitle = null;
    var _useInjectAnchor = useInjectAnchor(),
      contextHandleClick = _useInjectAnchor.handleClick,
      scrollTo = _useInjectAnchor.scrollTo,
      unregisterLink = _useInjectAnchor.unregisterLink,
      registerLink = _useInjectAnchor.registerLink,
      activeLink = _useInjectAnchor.activeLink;
    var _useConfigInject = useConfigInject('anchor', props),
      prefixCls = _useConfigInject.prefixCls;
    var handleClick = function handleClick(e) {
      var href = props.href;
      contextHandleClick(e, {
        title: mergedTitle,
        href: href
      });
      scrollTo(href);
    };
    watch(function () {
      return props.href;
    }, function (val, oldVal) {
      nextTick(function () {
        unregisterLink(oldVal);
        registerLink(val);
      });
    });
    onMounted(function () {
      registerLink(props.href);
    });
    onBeforeUnmount(function () {
      unregisterLink(props.href);
    });
    return function () {
      var _a;
      var href = props.href,
        target = props.target,
        _props$title = props.title,
        title = _props$title === void 0 ? slots.title : _props$title,
        _props$customTitlePro = props.customTitleProps,
        customTitleProps = _props$customTitlePro === void 0 ? {} : _props$customTitlePro;
      var pre = prefixCls.value;
      mergedTitle = typeof title === 'function' ? title(customTitleProps) : title;
      var active = activeLink.value === href;
      var wrapperClassName = classNames("".concat(pre, "-link"), _defineProperty({}, "".concat(pre, "-link-active"), active), attrs.class);
      var titleClassName = classNames("".concat(pre, "-link-title"), _defineProperty({}, "".concat(pre, "-link-title-active"), active));
      return _createVNode("div", _objectSpread(_objectSpread({}, attrs), {}, {
        "class": wrapperClassName
      }), [_createVNode("a", {
        "class": titleClassName,
        "href": href,
        "title": typeof mergedTitle === 'string' ? mergedTitle : '',
        "target": target,
        "onClick": handleClick
      }, [slots.customTitle ? slots.customTitle(customTitleProps) : mergedTitle]), (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)]);
    };
  }
});