import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import { resetComponent, textEllipsis } from '../../style';
// ============================== Shared ==============================
var genSharedAnchorStyle = function genSharedAnchorStyle(token) {
  var _$concat, _$concat3;
  var componentCls = token.componentCls,
    holderOffsetBlock = token.holderOffsetBlock,
    motionDurationSlow = token.motionDurationSlow,
    lineWidthBold = token.lineWidthBold,
    colorPrimary = token.colorPrimary,
    lineType = token.lineType,
    colorSplit = token.colorSplit;
  return _defineProperty({}, "".concat(componentCls, "-wrapper"), (_$concat3 = {
    marginBlockStart: -holderOffsetBlock,
    paddingBlockStart: holderOffsetBlock,
    // delete overflow: auto
    // overflow: 'auto',
    backgroundColor: 'transparent'
  }, _defineProperty(_$concat3, componentCls, _extends(_extends({}, resetComponent(token)), _defineProperty({
    position: 'relative',
    paddingInlineStart: lineWidthBold
  }, "".concat(componentCls, "-link"), (_$concat = {
    paddingBlock: token.anchorPaddingBlock,
    paddingInline: "".concat(token.anchorPaddingInline, "px 0"),
    '&-title': _extends(_extends({}, textEllipsis), {
      position: 'relative',
      display: 'block',
      marginBlockEnd: token.anchorTitleBlock,
      color: token.colorText,
      transition: "all ".concat(token.motionDurationSlow),
      '&:only-child': {
        marginBlockEnd: 0
      }
    })
  }, _defineProperty(_$concat, "&-active > ".concat(componentCls, "-link-title"), {
    color: token.colorPrimary
  }), _defineProperty(_$concat, "".concat(componentCls, "-link"), {
    paddingBlock: token.anchorPaddingBlockSecondary
  }), _$concat)))), _defineProperty(_$concat3, "&:not(".concat(componentCls, "-wrapper-horizontal)"), _defineProperty({}, componentCls, _defineProperty({
    '&::before': {
      position: 'absolute',
      left: {
        _skip_check_: true,
        value: 0
      },
      top: 0,
      height: '100%',
      borderInlineStart: "".concat(lineWidthBold, "px ").concat(lineType, " ").concat(colorSplit),
      content: '" "'
    }
  }, "".concat(componentCls, "-ink"), _defineProperty({
    position: 'absolute',
    left: {
      _skip_check_: true,
      value: 0
    },
    display: 'none',
    transform: 'translateY(-50%)',
    transition: "top ".concat(motionDurationSlow, " ease-in-out"),
    width: lineWidthBold,
    backgroundColor: colorPrimary
  }, "&".concat(componentCls, "-ink-visible"), {
    display: 'inline-block'
  })))), _defineProperty(_$concat3, "".concat(componentCls, "-fixed ").concat(componentCls, "-ink ").concat(componentCls, "-ink"), {
    display: 'none'
  }), _$concat3));
};
var genSharedAnchorHorizontalStyle = function genSharedAnchorHorizontalStyle(token) {
  var _componentCls2;
  var componentCls = token.componentCls,
    motionDurationSlow = token.motionDurationSlow,
    lineWidthBold = token.lineWidthBold,
    colorPrimary = token.colorPrimary;
  return _defineProperty({}, "".concat(componentCls, "-wrapper-horizontal"), _defineProperty({
    position: 'relative',
    '&::before': {
      position: 'absolute',
      left: {
        _skip_check_: true,
        value: 0
      },
      right: {
        _skip_check_: true,
        value: 0
      },
      bottom: 0,
      borderBottom: "1px ".concat(token.lineType, " ").concat(token.colorSplit),
      content: '" "'
    }
  }, componentCls, (_componentCls2 = {
    overflowX: 'scroll',
    position: 'relative',
    display: 'flex',
    scrollbarWidth: 'none' /* Firefox */,
    '&::-webkit-scrollbar': {
      display: 'none' /* Safari and Chrome */
    }
  }, _defineProperty(_componentCls2, "".concat(componentCls, "-link:first-of-type"), {
    paddingInline: 0
  }), _defineProperty(_componentCls2, "".concat(componentCls, "-ink"), {
    position: 'absolute',
    bottom: 0,
    transition: "left ".concat(motionDurationSlow, " ease-in-out, width ").concat(motionDurationSlow, " ease-in-out"),
    height: lineWidthBold,
    backgroundColor: colorPrimary
  }), _componentCls2)));
};
// ============================== Export ==============================
export default genComponentStyleHook('Anchor', function (token) {
  var fontSize = token.fontSize,
    fontSizeLG = token.fontSizeLG,
    padding = token.padding,
    paddingXXS = token.paddingXXS;
  var anchorToken = mergeToken(token, {
    holderOffsetBlock: paddingXXS,
    anchorPaddingBlock: paddingXXS,
    anchorPaddingBlockSecondary: paddingXXS / 2,
    anchorPaddingInline: padding,
    anchorTitleBlock: fontSize / 14 * 3,
    anchorBallSize: fontSizeLG / 2
  });
  return [genSharedAnchorStyle(anchorToken), genSharedAnchorHorizontalStyle(anchorToken)];
});