import { computed, inject, ref, provide } from 'vue';
var SizeContextKey = Symbol('SizeContextKey');
export var useInjectSize = function useInjectSize() {
  return inject(SizeContextKey, ref('default'));
};
export var useProviderSize = function useProviderSize(size) {
  var parentSize = useInjectSize();
  provide(SizeContextKey, computed(function () {
    return size.value || parentSize.value;
  }));
  return size;
};